/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateTraversableResolver
implements TraversableResolver {
    private Set<String> associations;

    public HibernateTraversableResolver(EntityPersister entityPersister, ConcurrentHashMap<EntityPersister, Set<String>> concurrentHashMap, SessionFactoryImplementor sessionFactoryImplementor) {
        this.associations = concurrentHashMap.get(entityPersister);
        if (this.associations == null) {
            this.associations = new HashSet<String>();
            this.addAssociationsToTheSetForAllProperties(entityPersister.getPropertyNames(), entityPersister.getPropertyTypes(), "", sessionFactoryImplementor);
            concurrentHashMap.put(entityPersister, this.associations);
        }
    }

    private void addAssociationsToTheSetForAllProperties(String[] stringArray, Type[] typeArray, String string, SessionFactoryImplementor sessionFactoryImplementor) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.addAssociationsToTheSetForOneProperty(stringArray[i], typeArray[i], string, sessionFactoryImplementor);
        }
    }

    private void addAssociationsToTheSetForOneProperty(String string, Type type, String string2, SessionFactoryImplementor sessionFactoryImplementor) {
        if (type.isCollectionType()) {
            CollectionType collectionType = (CollectionType)type;
            Type type2 = collectionType.getElementType(sessionFactoryImplementor);
            this.addAssociationsToTheSetForOneProperty(string, type2, string2, sessionFactoryImplementor);
        } else if (type.isEntityType() || type.isAnyType()) {
            this.associations.add(string2 + string);
        } else if (type.isComponentType()) {
            CompositeType compositeType = (CompositeType)type;
            this.addAssociationsToTheSetForAllProperties(compositeType.getPropertyNames(), compositeType.getSubtypes(), (string2.equals("") ? string : string2 + string) + ".", sessionFactoryImplementor);
        }
    }

    private String getStringBasedPath(Path.Node node, Path path) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Path.Node node2 : path) {
            if (node2.getName() == null) continue;
            stringBuilder.append(node2.getName()).append(".");
        }
        if (node.getName() == null) {
            throw new AssertionFailure("TraversableResolver being passed a traversableProperty with null name. pathToTraversableObject: " + stringBuilder.toString());
        }
        stringBuilder.append(node.getName());
        return stringBuilder.toString();
    }

    public boolean isReachable(Object object, Path.Node node, Class<?> clazz, Path path, ElementType elementType) {
        return Hibernate.isInitialized(object) && Hibernate.isPropertyInitialized(object, node.getName());
    }

    public boolean isCascadable(Object object, Path.Node node, Class<?> clazz, Path path, ElementType elementType) {
        String string = this.getStringBasedPath(node, path);
        return !this.associations.contains(string);
    }
}

