/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.beanvalidation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.beanvalidation.BeanValidationEventListener;
import org.hibernate.cfg.beanvalidation.GroupsPerOperation;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeSafeActivator {
    private static final Logger logger = LoggerFactory.getLogger(TypeSafeActivator.class);
    private static final String FACTORY_PROPERTY = "javax.persistence.validation.factory";

    TypeSafeActivator() {
    }

    public static void activateBeanValidation(EventListeners eventListeners, Properties properties) {
        ValidatorFactory validatorFactory = TypeSafeActivator.getValidatorFactory(properties);
        BeanValidationEventListener beanValidationEventListener = new BeanValidationEventListener(validatorFactory, properties);
        Serializable[] serializableArray = eventListeners.getPreInsertEventListeners();
        int n = serializableArray.length + 1;
        Serializable[] serializableArray2 = new PreInsertEventListener[n];
        System.arraycopy(serializableArray, 0, serializableArray2, 0, n - 1);
        serializableArray2[n - 1] = beanValidationEventListener;
        eventListeners.setPreInsertEventListeners((PreInsertEventListener[])serializableArray2);
        serializableArray = eventListeners.getPreUpdateEventListeners();
        n = serializableArray.length + 1;
        serializableArray2 = new PreUpdateEventListener[n];
        System.arraycopy(serializableArray, 0, serializableArray2, 0, n - 1);
        serializableArray2[n - 1] = beanValidationEventListener;
        eventListeners.setPreUpdateEventListeners((PreUpdateEventListener[])serializableArray2);
        serializableArray = eventListeners.getPreDeleteEventListeners();
        n = serializableArray.length + 1;
        serializableArray2 = new PreDeleteEventListener[n];
        System.arraycopy(serializableArray, 0, serializableArray2, 0, n - 1);
        serializableArray2[n - 1] = beanValidationEventListener;
        eventListeners.setPreDeleteEventListeners((PreDeleteEventListener[])serializableArray2);
    }

    public static void applyDDL(Collection<PersistentClass> collection, Properties properties) {
        ValidatorFactory validatorFactory = TypeSafeActivator.getValidatorFactory(properties);
        Class<?>[] classArray = new GroupsPerOperation(properties).get(GroupsPerOperation.Operation.DDL);
        HashSet hashSet = new HashSet(Arrays.asList(classArray));
        for (PersistentClass persistentClass : collection) {
            Class clazz;
            String string = persistentClass.getClassName();
            if (string == null || string.length() == 0) continue;
            try {
                clazz = ReflectHelper.classForName(string, TypeSafeActivator.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionFailure("Entity class not found", classNotFoundException);
            }
            try {
                TypeSafeActivator.applyDDL("", persistentClass, clazz, validatorFactory, hashSet, true);
            }
            catch (Exception exception) {
                logger.warn("Unable to apply constraints on DDL for " + string, exception);
            }
        }
    }

    private static void applyDDL(String string, PersistentClass persistentClass, Class<?> clazz, ValidatorFactory validatorFactory, Set<Class<?>> set, boolean bl) {
        BeanDescriptor beanDescriptor = validatorFactory.getValidator().getConstraintsForClass(clazz);
        for (PropertyDescriptor propertyDescriptor : beanDescriptor.getConstrainedProperties()) {
            Property property = TypeSafeActivator.findPropertyByName(persistentClass, string + propertyDescriptor.getPropertyName());
            boolean bl2 = false;
            if (property == null) continue;
            bl2 = TypeSafeActivator.applyConstraints(propertyDescriptor.getConstraintDescriptors(), property, propertyDescriptor, set, bl);
            if (!property.isComposite() || !propertyDescriptor.isCascaded()) continue;
            Class clazz2 = ((Component)property.getValue()).getComponentClass();
            boolean bl3 = bl && bl2;
            TypeSafeActivator.applyDDL(string + propertyDescriptor.getPropertyName() + ".", persistentClass, clazz2, validatorFactory, set, bl3);
        }
    }

    private static boolean applyConstraints(Set<ConstraintDescriptor<?>> set, Property property, PropertyDescriptor propertyDescriptor, Set<Class<?>> set2, boolean bl) {
        boolean bl2 = false;
        for (ConstraintDescriptor<?> constraintDescriptor : set) {
            if (set2 != null && Collections.disjoint(constraintDescriptor.getGroups(), set2)) continue;
            if (bl) {
                bl2 = bl2 || TypeSafeActivator.applyNotNull(property, constraintDescriptor);
            }
            TypeSafeActivator.applyDigits(property, constraintDescriptor);
            TypeSafeActivator.applySize(property, constraintDescriptor, propertyDescriptor);
            TypeSafeActivator.applyMin(property, constraintDescriptor);
            TypeSafeActivator.applyMax(property, constraintDescriptor);
            TypeSafeActivator.applyLength(property, constraintDescriptor, propertyDescriptor);
            bl2 = bl2 || TypeSafeActivator.applyConstraints(constraintDescriptor.getComposingConstraints(), property, propertyDescriptor, null, bl);
        }
        return bl2;
    }

    private static void applyMin(Property property, ConstraintDescriptor<?> constraintDescriptor) {
        if (Min.class.equals(constraintDescriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> constraintDescriptor2 = constraintDescriptor;
            long l = ((Min)constraintDescriptor2.getAnnotation()).value();
            Column column = (Column)property.getColumnIterator().next();
            column.setCheckConstraint(column.getName() + ">=" + l);
        }
    }

    private static void applyMax(Property property, ConstraintDescriptor<?> constraintDescriptor) {
        if (Max.class.equals(constraintDescriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> constraintDescriptor2 = constraintDescriptor;
            long l = ((Max)constraintDescriptor2.getAnnotation()).value();
            Column column = (Column)property.getColumnIterator().next();
            column.setCheckConstraint(column.getName() + "<=" + l);
        }
    }

    private static boolean applyNotNull(Property property, ConstraintDescriptor<?> constraintDescriptor) {
        boolean bl = false;
        if (NotNull.class.equals(constraintDescriptor.getAnnotation().annotationType())) {
            if (!(property.getPersistentClass() instanceof SingleTableSubclass) && !property.isComposite()) {
                Iterator iterator = property.getColumnIterator();
                while (iterator.hasNext()) {
                    ((Column)iterator.next()).setNullable(false);
                    bl = true;
                }
            }
            bl = true;
        }
        return bl;
    }

    private static void applyDigits(Property property, ConstraintDescriptor<?> constraintDescriptor) {
        if (Digits.class.equals(constraintDescriptor.getAnnotation().annotationType())) {
            ConstraintDescriptor<?> constraintDescriptor2 = constraintDescriptor;
            int n = ((Digits)constraintDescriptor2.getAnnotation()).integer();
            int n2 = ((Digits)constraintDescriptor2.getAnnotation()).fraction();
            Column column = (Column)property.getColumnIterator().next();
            column.setPrecision(n + n2);
            column.setScale(n2);
        }
    }

    private static void applySize(Property property, ConstraintDescriptor<?> constraintDescriptor, PropertyDescriptor propertyDescriptor) {
        if (Size.class.equals(constraintDescriptor.getAnnotation().annotationType()) && String.class.equals((Object)propertyDescriptor.getElementClass())) {
            ConstraintDescriptor<?> constraintDescriptor2 = constraintDescriptor;
            int n = ((Size)constraintDescriptor2.getAnnotation()).max();
            Column column = (Column)property.getColumnIterator().next();
            if (n < Integer.MAX_VALUE) {
                column.setLength(n);
            }
        }
    }

    private static void applyLength(Property property, ConstraintDescriptor<?> constraintDescriptor, PropertyDescriptor propertyDescriptor) {
        if ("org.hibernate.validator.constraints.Length".equals(constraintDescriptor.getAnnotation().annotationType().getName()) && String.class.equals((Object)propertyDescriptor.getElementClass())) {
            int n = (Integer)constraintDescriptor.getAttributes().get("max");
            Column column = (Column)property.getColumnIterator().next();
            if (n < Integer.MAX_VALUE) {
                column.setLength(n);
            }
        }
    }

    private static Property findPropertyByName(PersistentClass persistentClass, String string) {
        Property property = null;
        Property property2 = persistentClass.getIdentifierProperty();
        String string2 = property2 != null ? property2.getName() : null;
        try {
            if (string == null || string.length() == 0 || string.equals(string2)) {
                property = property2;
            } else {
                if (string.indexOf(string2 + ".") == 0) {
                    property = property2;
                    string = string.substring(string2.length() + 1);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = (String)stringTokenizer.nextElement();
                    if (property == null) {
                        property = persistentClass.getProperty(string3);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(string3);
                }
            }
        }
        catch (MappingException mappingException) {
            try {
                if (persistentClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = (String)stringTokenizer.nextElement();
                    if (property == null) {
                        property = persistentClass.getIdentifierMapper().getProperty(string4);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(string4);
                }
            }
            catch (MappingException mappingException2) {
                return null;
            }
        }
        return property;
    }

    private static ValidatorFactory getValidatorFactory(Map<Object, Object> map) {
        Object object;
        ValidatorFactory validatorFactory = null;
        if (map != null && (object = map.get(FACTORY_PROPERTY)) != null) {
            try {
                validatorFactory = (ValidatorFactory)ValidatorFactory.class.cast(object);
            }
            catch (ClassCastException classCastException) {
                throw new HibernateException("Property javax.persistence.validation.factory should contain an object of type " + ValidatorFactory.class.getName());
            }
        }
        if (validatorFactory == null) {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (Exception exception) {
                throw new HibernateException("Unable to build the default ValidatorFactory", exception);
            }
        }
        return validatorFactory;
    }
}

