/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.TypedValue;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.IdentitySet;
import org.hibernate.util.MarkerObject;

public abstract class AbstractPersistentCollection
implements Serializable,
PersistentCollection {
    private transient SessionImplementor session;
    private boolean initialized;
    private transient List operationQueue;
    private transient boolean directlyAccessible;
    private transient boolean initializing;
    private Object owner;
    private int cachedSize = -1;
    private String role;
    private Serializable key;
    private boolean dirty;
    private Serializable storedSnapshot;
    protected static final Object UNKNOWN = new MarkerObject("UNKNOWN");

    public final String getRole() {
        return this.role;
    }

    public final Serializable getKey() {
        return this.key;
    }

    public final boolean isUnreferenced() {
        return this.role == null;
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    public final void clearDirty() {
        this.dirty = false;
    }

    public final void dirty() {
        this.dirty = true;
    }

    public final Serializable getStoredSnapshot() {
        return this.storedSnapshot;
    }

    public abstract boolean empty();

    protected final void read() {
        this.initialize(false);
    }

    protected boolean readSize() {
        if (!this.initialized) {
            if (this.cachedSize != -1 && !this.hasQueuedOperations()) {
                return true;
            }
            this.throwLazyInitializationExceptionIfNotConnected();
            CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
            CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
            if (collectionPersister.isExtraLazy()) {
                if (this.hasQueuedOperations()) {
                    this.session.flush();
                }
                this.cachedSize = collectionPersister.getSize(collectionEntry.getLoadedKey(), this.session);
                return true;
            }
        }
        this.read();
        return false;
    }

    protected Boolean readIndexExistence(Object object) {
        if (!this.initialized) {
            this.throwLazyInitializationExceptionIfNotConnected();
            CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
            CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
            if (collectionPersister.isExtraLazy()) {
                if (this.hasQueuedOperations()) {
                    this.session.flush();
                }
                return new Boolean(collectionPersister.indexExists(collectionEntry.getLoadedKey(), object, this.session));
            }
        }
        this.read();
        return null;
    }

    protected Boolean readElementExistence(Object object) {
        if (!this.initialized) {
            this.throwLazyInitializationExceptionIfNotConnected();
            CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
            CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
            if (collectionPersister.isExtraLazy()) {
                if (this.hasQueuedOperations()) {
                    this.session.flush();
                }
                return new Boolean(collectionPersister.elementExists(collectionEntry.getLoadedKey(), object, this.session));
            }
        }
        this.read();
        return null;
    }

    protected Object readElementByIndex(Object object) {
        if (!this.initialized) {
            this.throwLazyInitializationExceptionIfNotConnected();
            CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
            CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
            if (collectionPersister.isExtraLazy()) {
                if (this.hasQueuedOperations()) {
                    this.session.flush();
                }
                return collectionPersister.getElementByIndex(collectionEntry.getLoadedKey(), object, this.session, this.owner);
            }
        }
        this.read();
        return UNKNOWN;
    }

    protected int getCachedSize() {
        return this.cachedSize;
    }

    private final boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen() && this.session.getPersistenceContext().containsCollection(this);
    }

    protected final void write() {
        this.initialize(true);
        this.dirty();
    }

    protected boolean isOperationQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollection();
    }

    protected boolean isPutQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseOneToManyOrNoOrphanDelete();
    }

    protected boolean isClearQueueEnabled() {
        return !this.initialized && this.isConnectedToSession() && this.isInverseCollectionNoOrphanDelete();
    }

    private boolean isInverseCollection() {
        CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
        return collectionEntry != null && collectionEntry.getLoadedPersister().isInverse();
    }

    private boolean isInverseCollectionNoOrphanDelete() {
        CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
        return collectionEntry != null && collectionEntry.getLoadedPersister().isInverse() && !collectionEntry.getLoadedPersister().hasOrphanDelete();
    }

    private boolean isInverseOneToManyOrNoOrphanDelete() {
        CollectionEntry collectionEntry = this.session.getPersistenceContext().getCollectionEntry(this);
        return collectionEntry != null && collectionEntry.getLoadedPersister().isInverse() && (collectionEntry.getLoadedPersister().isOneToMany() || !collectionEntry.getLoadedPersister().hasOrphanDelete());
    }

    protected final void queueOperation(Object object) {
        if (this.operationQueue == null) {
            this.operationQueue = new ArrayList(10);
        }
        this.operationQueue.add(object);
        this.dirty = true;
    }

    protected final void performQueuedOperations() {
        for (int i = 0; i < this.operationQueue.size(); ++i) {
            ((DelayedOperation)this.operationQueue.get(i)).operate();
        }
    }

    public void setSnapshot(Serializable serializable, String string, Serializable serializable2) {
        this.key = serializable;
        this.role = string;
        this.storedSnapshot = serializable2;
    }

    public void postAction() {
        this.operationQueue = null;
        this.cachedSize = -1;
        this.clearDirty();
    }

    public AbstractPersistentCollection() {
    }

    protected AbstractPersistentCollection(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
    }

    public Object getValue() {
        return this;
    }

    public void beginRead() {
        this.initializing = true;
    }

    public boolean endRead() {
        return this.afterInitialize();
    }

    public boolean afterInitialize() {
        this.setInitialized();
        if (this.operationQueue != null) {
            this.performQueuedOperations();
            this.operationQueue = null;
            this.cachedSize = -1;
            return false;
        }
        return true;
    }

    protected final void initialize(boolean bl) {
        if (!this.initialized) {
            if (this.initializing) {
                throw new LazyInitializationException("illegal access to loading collection");
            }
            this.throwLazyInitializationExceptionIfNotConnected();
            this.session.initializeCollection(this, bl);
        }
    }

    private void throwLazyInitializationExceptionIfNotConnected() {
        if (!this.isConnectedToSession()) {
            this.throwLazyInitializationException("no session or session was closed");
        }
        if (!this.session.isConnected()) {
            this.throwLazyInitializationException("session is disconnected");
        }
    }

    private void throwLazyInitializationException(String string) {
        throw new LazyInitializationException("failed to lazily initialize a collection" + (this.role == null ? "" : " of role: " + this.role) + ", " + string);
    }

    protected final void setInitialized() {
        this.initializing = false;
        this.initialized = true;
    }

    protected final void setDirectlyAccessible(boolean bl) {
        this.directlyAccessible = bl;
    }

    public boolean isDirectlyAccessible() {
        return this.directlyAccessible;
    }

    public final boolean unsetSession(SessionImplementor sessionImplementor) {
        if (sessionImplementor == this.session) {
            this.session = null;
            return true;
        }
        return false;
    }

    public final boolean setCurrentSession(SessionImplementor sessionImplementor) throws HibernateException {
        if (sessionImplementor == this.session) {
            return false;
        }
        if (this.isConnectedToSession()) {
            CollectionEntry collectionEntry = sessionImplementor.getPersistenceContext().getCollectionEntry(this);
            if (collectionEntry == null) {
                throw new HibernateException("Illegal attempt to associate a collection with two open sessions");
            }
            throw new HibernateException("Illegal attempt to associate a collection with two open sessions: " + MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), sessionImplementor.getFactory()));
        }
        this.session = sessionImplementor;
        return true;
    }

    public boolean needsRecreate(CollectionPersister collectionPersister) {
        return false;
    }

    public final void forceInitialization() throws HibernateException {
        if (!this.initialized) {
            if (this.initializing) {
                throw new AssertionFailure("force initialize loading collection");
            }
            if (this.session == null) {
                throw new HibernateException("collection is not associated with any session");
            }
            if (!this.session.isConnected()) {
                throw new HibernateException("disconnected session");
            }
            this.session.initializeCollection(this, false);
        }
    }

    protected final Serializable getSnapshot() {
        return this.session.getPersistenceContext().getSnapshot(this);
    }

    public final boolean wasInitialized() {
        return this.initialized;
    }

    public boolean isRowUpdatePossible() {
        return true;
    }

    public final boolean hasQueuedOperations() {
        return this.operationQueue != null;
    }

    public final Iterator queuedAdditionIterator() {
        if (this.hasQueuedOperations()) {
            return new Iterator(){
                int i = 0;

                public Object next() {
                    return ((DelayedOperation)AbstractPersistentCollection.this.operationQueue.get(this.i++)).getAddedInstance();
                }

                public boolean hasNext() {
                    return this.i < AbstractPersistentCollection.this.operationQueue.size();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return EmptyIterator.INSTANCE;
    }

    public final Collection getQueuedOrphans(String string) {
        if (this.hasQueuedOperations()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(this.operationQueue.size());
            ArrayList<Object> arrayList2 = new ArrayList<Object>(this.operationQueue.size());
            for (int i = 0; i < this.operationQueue.size(); ++i) {
                DelayedOperation delayedOperation = (DelayedOperation)this.operationQueue.get(i);
                arrayList.add(delayedOperation.getAddedInstance());
                arrayList2.add(delayedOperation.getOrphan());
            }
            return AbstractPersistentCollection.getOrphans(arrayList2, arrayList, string, this.session);
        }
        return CollectionHelper.EMPTY_COLLECTION;
    }

    public void preInsert(CollectionPersister collectionPersister) throws HibernateException {
    }

    public void afterRowInsert(CollectionPersister collectionPersister, Object object, int n) throws HibernateException {
    }

    public abstract Collection getOrphans(Serializable var1, String var2) throws HibernateException;

    public final SessionImplementor getSession() {
        return this.session;
    }

    protected static Collection getOrphans(Collection collection, Collection collection2, String string, SessionImplementor sessionImplementor) throws HibernateException {
        Serializable serializable;
        if (collection2.size() == 0) {
            return collection;
        }
        if (collection.size() == 0) {
            return collection;
        }
        Type type = sessionImplementor.getFactory().getEntityPersister(string).getIdentifierType();
        ArrayList arrayList = new ArrayList();
        HashSet<TypedValue> hashSet = new HashSet<TypedValue>();
        IdentitySet identitySet = new IdentitySet();
        for (Object e : collection2) {
            if (e == null || !ForeignKeys.isNotTransient(string, e, null, sessionImplementor)) continue;
            serializable = sessionImplementor.getPersistenceContext().getEntry(e);
            if (serializable != null && ((EntityEntry)serializable).getStatus() == Status.SAVING) {
                identitySet.add(e);
                continue;
            }
            Serializable serializable2 = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, e, sessionImplementor);
            hashSet.add(new TypedValue(type, serializable2, sessionImplementor.getEntityMode()));
        }
        for (Object e : collection) {
            if (identitySet.contains(e) || hashSet.contains(new TypedValue(type, serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, e, sessionImplementor), sessionImplementor.getEntityMode()))) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    static void identityRemove(Collection collection, Object object, String string, SessionImplementor sessionImplementor) throws HibernateException {
        if (object != null && ForeignKeys.isNotTransient(string, object, null, sessionImplementor)) {
            Type type = sessionImplementor.getFactory().getEntityPersister(string).getIdentifierType();
            Serializable serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, object, sessionImplementor);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Serializable serializable2 = ForeignKeys.getEntityIdentifierIfNotUnsaved(string, iterator.next(), sessionImplementor);
                if (!type.isEqual(serializable, serializable2, sessionImplementor.getEntityMode(), sessionImplementor.getFactory())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public Object getIdentifier(Object object, int n) {
        throw new UnsupportedOperationException();
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    protected static interface DelayedOperation {
        public void operate();

        public Object getAddedInstance();

        public Object getOrphan();
    }

    final class ListProxy
    implements List {
        private final List list;

        ListProxy(List list) {
            this.list = list;
        }

        public void add(int n, Object object) {
            AbstractPersistentCollection.this.write();
            this.list.add(n, object);
        }

        public boolean add(Object object) {
            AbstractPersistentCollection.this.write();
            return this.list.add(object);
        }

        public boolean addAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(collection);
        }

        public boolean addAll(int n, Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.list.addAll(n, collection);
        }

        public void clear() {
            AbstractPersistentCollection.this.write();
            this.list.clear();
        }

        public boolean contains(Object object) {
            return this.list.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.list.containsAll(collection);
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.list.iterator());
        }

        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return new ListIteratorProxy(this.list.listIterator());
        }

        public ListIterator listIterator(int n) {
            return new ListIteratorProxy(this.list.listIterator(n));
        }

        public Object remove(int n) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(n);
        }

        public boolean remove(Object object) {
            AbstractPersistentCollection.this.write();
            return this.list.remove(object);
        }

        public boolean removeAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.list.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.list.retainAll(collection);
        }

        public Object set(int n, Object object) {
            AbstractPersistentCollection.this.write();
            return this.list.set(n, object);
        }

        public int size() {
            return this.list.size();
        }

        public List subList(int n, int n2) {
            return this.list.subList(n, n2);
        }

        public Object[] toArray() {
            return this.list.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.list.toArray(objectArray);
        }
    }

    class SetProxy
    implements Set {
        final Collection set;

        SetProxy(Collection collection) {
            this.set = collection;
        }

        public boolean add(Object object) {
            AbstractPersistentCollection.this.write();
            return this.set.add(object);
        }

        public boolean addAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.set.addAll(collection);
        }

        public void clear() {
            AbstractPersistentCollection.this.write();
            this.set.clear();
        }

        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return this.set.containsAll(collection);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public Iterator iterator() {
            return new IteratorProxy(this.set.iterator());
        }

        public boolean remove(Object object) {
            AbstractPersistentCollection.this.write();
            return this.set.remove(object);
        }

        public boolean removeAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.set.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            AbstractPersistentCollection.this.write();
            return this.set.retainAll(collection);
        }

        public int size() {
            return this.set.size();
        }

        public Object[] toArray() {
            return this.set.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.set.toArray(objectArray);
        }
    }

    final class ListIteratorProxy
    implements ListIterator {
        private final ListIterator iter;

        ListIteratorProxy(ListIterator listIterator) {
            this.iter = listIterator;
        }

        public void add(Object object) {
            AbstractPersistentCollection.this.write();
            this.iter.add(object);
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        public Object next() {
            return this.iter.next();
        }

        public int nextIndex() {
            return this.iter.nextIndex();
        }

        public Object previous() {
            return this.iter.previous();
        }

        public int previousIndex() {
            return this.iter.previousIndex();
        }

        public void remove() {
            AbstractPersistentCollection.this.write();
            this.iter.remove();
        }

        public void set(Object object) {
            AbstractPersistentCollection.this.write();
            this.iter.set(object);
        }
    }

    final class IteratorProxy
    implements Iterator {
        private final Iterator iter;

        IteratorProxy(Iterator iterator) {
            this.iter = iterator;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            return this.iter.next();
        }

        public void remove() {
            AbstractPersistentCollection.this.write();
            this.iter.remove();
        }
    }
}

