/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public class PersistentElementHolder
extends AbstractPersistentCollection {
    protected Element element;

    public PersistentElementHolder(SessionImplementor sessionImplementor, Element element) {
        super(sessionImplementor);
        this.element = element;
        this.setInitialized();
    }

    public Serializable getSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        List list = this.element.elements(collectionPersister.getElementNodeName());
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            Object object = type.fromXMLNode(element, collectionPersister.getFactory());
            Object object2 = type.deepCopy(object, this.getSession().getEntityMode(), collectionPersister.getFactory());
            arrayList.add(object2);
        }
        return arrayList;
    }

    public Collection getOrphans(Serializable serializable, String string) throws HibernateException {
        return CollectionHelper.EMPTY_COLLECTION;
    }

    public PersistentElementHolder(SessionImplementor sessionImplementor, CollectionPersister collectionPersister, Serializable serializable) throws HibernateException {
        super(sessionImplementor);
        Element element = (Element)sessionImplementor.getPersistenceContext().getCollectionOwner(serializable, collectionPersister);
        if (element == null) {
            throw new AssertionFailure("null owner");
        }
        String string = collectionPersister.getNodeName();
        if (".".equals(string)) {
            this.element = element;
        } else {
            this.element = element.element(string);
            if (this.element == null) {
                this.element = element.addElement(string);
            }
        }
    }

    public boolean isWrapper(Object object) {
        return this.element == object;
    }

    public boolean equalsSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        ArrayList arrayList = (ArrayList)this.getSnapshot();
        List list = this.element.elements(collectionPersister.getElementNodeName());
        if (arrayList.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element;
            Object object;
            Object e = arrayList.get(i);
            if (!type.isDirty(e, object = type.fromXMLNode(element = (Element)list.get(i), collectionPersister.getFactory()), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public boolean isSnapshotEmpty(Serializable serializable) {
        return ((Collection)((Object)serializable)).isEmpty();
    }

    public boolean empty() {
        return !this.element.elementIterator().hasNext();
    }

    public Object readFrom(ResultSet resultSet, CollectionPersister collectionPersister, CollectionAliases collectionAliases, Object object) throws HibernateException, SQLException {
        Object object2 = collectionPersister.readElement(resultSet, object, collectionAliases.getSuffixedElementAliases(), this.getSession());
        Type type = collectionPersister.getElementType();
        Element element = this.element.addElement(collectionPersister.getElementNodeName());
        type.setToXMLNode(element, object2, collectionPersister.getFactory());
        return object2;
    }

    public Iterator entries(CollectionPersister collectionPersister) {
        Type type = collectionPersister.getElementType();
        List list = this.element.elements(collectionPersister.getElementNodeName());
        int n = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Element element = (Element)list.get(i);
            Object object = type.fromXMLNode(element, collectionPersister.getFactory());
            arrayList.add(object);
        }
        return arrayList.iterator();
    }

    public void beforeInitialize(CollectionPersister collectionPersister, int n) {
    }

    public boolean isDirectlyAccessible() {
        return true;
    }

    public void initializeFromCache(CollectionPersister collectionPersister, Serializable serializable, Object object) throws HibernateException {
        Type type = collectionPersister.getElementType();
        Serializable[] serializableArray = (Serializable[])serializable;
        for (int i = 0; i < serializableArray.length; ++i) {
            Object object2 = type.assemble(serializableArray[i], this.getSession(), object);
            Element element = this.element.addElement(collectionPersister.getElementNodeName());
            type.setToXMLNode(element, object2, collectionPersister.getFactory());
        }
    }

    public Serializable disassemble(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        List list = this.element.elements(collectionPersister.getElementNodeName());
        int n = list.size();
        Serializable[] serializableArray = new Serializable[n];
        for (int i = 0; i < n; ++i) {
            Element element = (Element)list.get(i);
            Object object = type.fromXMLNode(element, collectionPersister.getFactory());
            serializableArray[i] = type.disassemble(object, this.getSession(), null);
        }
        return serializableArray;
    }

    public Object getValue() {
        return this.element;
    }

    public Iterator getDeletes(CollectionPersister collectionPersister, boolean bl) throws HibernateException {
        Type type = collectionPersister.getElementType();
        ArrayList arrayList = (ArrayList)this.getSnapshot();
        List list = this.element.elements(collectionPersister.getElementNodeName());
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (i >= list.size()) {
                arrayList2.add(e);
                continue;
            }
            Element element = (Element)list.get(i);
            Object object = type.fromXMLNode(element, collectionPersister.getFactory());
            if (!type.isDirty(e, object, this.getSession())) continue;
            arrayList2.add(e);
        }
        return arrayList2.iterator();
    }

    public boolean needsInserting(Object object, int n, Type type) throws HibernateException {
        ArrayList arrayList = (ArrayList)this.getSnapshot();
        return n >= arrayList.size() || type.isDirty(arrayList.get(n), object, this.getSession());
    }

    public boolean needsUpdating(Object object, int n, Type type) throws HibernateException {
        return false;
    }

    public Object getIndex(Object object, int n, CollectionPersister collectionPersister) {
        throw new UnsupportedOperationException();
    }

    public Object getElement(Object object) {
        return object;
    }

    public Object getSnapshotElement(Object object, int n) {
        throw new UnsupportedOperationException();
    }

    public boolean entryExists(Object object, int n) {
        return object != null;
    }
}

