/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentSet
extends AbstractPersistentCollection
implements Set {
    protected Set set;
    protected transient List tempList;

    public PersistentSet() {
    }

    public PersistentSet(SessionImplementor sessionImplementor) {
        super(sessionImplementor);
    }

    public PersistentSet(SessionImplementor sessionImplementor, Set set) {
        super(sessionImplementor);
        this.set = set;
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public Serializable getSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.set.size());
        Iterator iterator = this.set.iterator();
        while (iterator.hasNext()) {
            Object object = collectionPersister.getElementType().deepCopy(iterator.next(), entityMode, collectionPersister.getFactory());
            hashMap.put(object, object);
        }
        return hashMap;
    }

    public Collection getOrphans(Serializable serializable, String string) throws HibernateException {
        Map map = (Map)((Object)serializable);
        return PersistentSet.getOrphans(map.keySet(), this.set, string, this.getSession());
    }

    public boolean equalsSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        Map map = (Map)((Object)this.getSnapshot());
        if (map.size() != this.set.size()) {
            return false;
        }
        for (Object e : this.set) {
            Object v = map.get(e);
            if (v != null && !type.isDirty(v, e, this.getSession())) continue;
            return false;
        }
        return true;
    }

    public boolean isSnapshotEmpty(Serializable serializable) {
        return ((Map)((Object)serializable)).isEmpty();
    }

    public void beforeInitialize(CollectionPersister collectionPersister, int n) {
        this.set = (Set)collectionPersister.getCollectionType().instantiate(n);
    }

    public void initializeFromCache(CollectionPersister collectionPersister, Serializable serializable, Object object) throws HibernateException {
        Serializable[] serializableArray = (Serializable[])serializable;
        int n = serializableArray.length;
        this.beforeInitialize(collectionPersister, n);
        for (int i = 0; i < n; ++i) {
            Object object2 = collectionPersister.getElementType().assemble(serializableArray[i], this.getSession(), object);
            if (object2 == null) continue;
            this.set.add(object2);
        }
    }

    public boolean empty() {
        return this.set.isEmpty();
    }

    public int size() {
        return this.readSize() ? this.getCachedSize() : this.set.size();
    }

    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.set.isEmpty();
    }

    public boolean contains(Object object) {
        Boolean bl = this.readElementExistence(object);
        return bl == null ? this.set.contains(object) : bl.booleanValue();
    }

    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this.set.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.set.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.read();
        return this.set.toArray(objectArray);
    }

    public boolean add(Object object) {
        Boolean bl;
        Boolean bl2 = bl = this.isOperationQueueEnabled() ? this.readElementExistence(object) : null;
        if (bl == null) {
            this.initialize(true);
            if (this.set.add(object)) {
                this.dirty();
                return true;
            }
            return false;
        }
        if (bl.booleanValue()) {
            return false;
        }
        this.queueOperation(new SimpleAdd(object));
        return true;
    }

    public boolean remove(Object object) {
        Boolean bl;
        Boolean bl2 = bl = this.isPutQueueEnabled() ? this.readElementExistence(object) : null;
        if (bl == null) {
            this.initialize(true);
            if (this.set.remove(object)) {
                this.dirty();
                return true;
            }
            return false;
        }
        if (bl.booleanValue()) {
            this.queueOperation(new SimpleRemove(object));
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        this.read();
        return this.set.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        if (collection.size() > 0) {
            this.initialize(true);
            if (this.set.addAll(collection)) {
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean retainAll(Collection collection) {
        this.initialize(true);
        if (this.set.retainAll(collection)) {
            this.dirty();
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (collection.size() > 0) {
            this.initialize(true);
            if (this.set.removeAll(collection)) {
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.set.isEmpty()) {
                this.set.clear();
                this.dirty();
            }
        }
    }

    public String toString() {
        this.read();
        return this.set.toString();
    }

    public Object readFrom(ResultSet resultSet, CollectionPersister collectionPersister, CollectionAliases collectionAliases, Object object) throws HibernateException, SQLException {
        Object object2 = collectionPersister.readElement(resultSet, object, collectionAliases.getSuffixedElementAliases(), this.getSession());
        if (object2 != null) {
            this.tempList.add(object2);
        }
        return object2;
    }

    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    public boolean endRead() {
        this.set.addAll(this.tempList);
        this.tempList = null;
        this.setInitialized();
        return true;
    }

    public Iterator entries(CollectionPersister collectionPersister) {
        return this.set.iterator();
    }

    public Serializable disassemble(CollectionPersister collectionPersister) throws HibernateException {
        Serializable[] serializableArray = new Serializable[this.set.size()];
        Iterator iterator = this.set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            serializableArray[n++] = collectionPersister.getElementType().disassemble(iterator.next(), this.getSession(), null);
        }
        return serializableArray;
    }

    public Iterator getDeletes(CollectionPersister collectionPersister, boolean bl) throws HibernateException {
        Type type = collectionPersister.getElementType();
        Map map = (Map)((Object)this.getSnapshot());
        ArrayList<Object> arrayList = new ArrayList<Object>(map.size());
        for (Object object : map.keySet()) {
            if (this.set.contains(object)) continue;
            arrayList.add(object);
        }
        for (Object object : this.set) {
            Object v = map.get(object);
            if (v == null || !type.isDirty(object, v, this.getSession())) continue;
            arrayList.add(v);
        }
        return arrayList.iterator();
    }

    public boolean needsInserting(Object object, int n, Type type) throws HibernateException {
        Map map = (Map)((Object)this.getSnapshot());
        Object v = map.get(object);
        return v == null || type.isDirty(v, object, this.getSession());
    }

    public boolean needsUpdating(Object object, int n, Type type) {
        return false;
    }

    public boolean isRowUpdatePossible() {
        return false;
    }

    public Object getIndex(Object object, int n, CollectionPersister collectionPersister) {
        throw new UnsupportedOperationException("Sets don't have indexes");
    }

    public Object getElement(Object object) {
        return object;
    }

    public Object getSnapshotElement(Object object, int n) {
        throw new UnsupportedOperationException("Sets don't support updating by element");
    }

    public boolean equals(Object object) {
        this.read();
        return ((Object)this.set).equals(object);
    }

    public int hashCode() {
        this.read();
        return ((Object)this.set).hashCode();
    }

    public boolean entryExists(Object object, int n) {
        return true;
    }

    public boolean isWrapper(Object object) {
        return this.set == object;
    }

    final class SimpleRemove
    implements AbstractPersistentCollection.DelayedOperation {
        private Object value;

        public SimpleRemove(Object object) {
            this.value = object;
        }

        public void operate() {
            PersistentSet.this.set.remove(this.value);
        }

        public Object getAddedInstance() {
            return null;
        }

        public Object getOrphan() {
            return this.value;
        }
    }

    final class SimpleAdd
    implements AbstractPersistentCollection.DelayedOperation {
        private Object value;

        public SimpleAdd(Object object) {
            this.value = object;
        }

        public void operate() {
            PersistentSet.this.set.add(this.value);
        }

        public Object getAddedInstance() {
            return this.value;
        }

        public Object getOrphan() {
            return null;
        }
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation {
        Clear() {
        }

        public void operate() {
            PersistentSet.this.set.clear();
        }

        public Object getAddedInstance() {
            return null;
        }

        public Object getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }
}

