/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentMap;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.BasicCollectionPersister;

public class PersistentSortedMap
extends PersistentMap
implements SortedMap {
    protected Comparator comparator;

    protected Serializable snapshot(BasicCollectionPersister basicCollectionPersister, EntityMode entityMode) throws HibernateException {
        TreeMap treeMap = new TreeMap(this.comparator);
        for (Map.Entry entry : this.map.entrySet()) {
            treeMap.put(entry.getKey(), basicCollectionPersister.getElementType().deepCopy(entry.getValue(), entityMode, basicCollectionPersister.getFactory()));
        }
        return treeMap;
    }

    public PersistentSortedMap(SessionImplementor sessionImplementor) {
        super(sessionImplementor);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public PersistentSortedMap(SessionImplementor sessionImplementor, SortedMap sortedMap) {
        super(sessionImplementor, sortedMap);
        this.comparator = sortedMap.comparator();
    }

    public PersistentSortedMap() {
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public SortedMap subMap(Object object, Object object2) {
        this.read();
        SortedMap sortedMap = ((SortedMap)this.map).subMap(object, object2);
        return new SortedSubMap(sortedMap);
    }

    public SortedMap headMap(Object object) {
        this.read();
        SortedMap sortedMap = ((SortedMap)this.map).headMap(object);
        return new SortedSubMap(sortedMap);
    }

    public SortedMap tailMap(Object object) {
        this.read();
        SortedMap sortedMap = ((SortedMap)this.map).tailMap(object);
        return new SortedSubMap(sortedMap);
    }

    public Object firstKey() {
        this.read();
        return ((SortedMap)this.map).firstKey();
    }

    public Object lastKey() {
        this.read();
        return ((SortedMap)this.map).lastKey();
    }

    class SortedSubMap
    implements SortedMap {
        SortedMap submap;

        SortedSubMap(SortedMap sortedMap) {
            this.submap = sortedMap;
        }

        public int size() {
            return this.submap.size();
        }

        public boolean isEmpty() {
            return this.submap.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.submap.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.submap.containsValue(object);
        }

        public Object get(Object object) {
            return this.submap.get(object);
        }

        public Object put(Object object, Object object2) {
            PersistentSortedMap.this.write();
            return this.submap.put(object, object2);
        }

        public Object remove(Object object) {
            PersistentSortedMap.this.write();
            return this.submap.remove(object);
        }

        public void putAll(Map map) {
            PersistentSortedMap.this.write();
            this.submap.putAll(map);
        }

        public void clear() {
            PersistentSortedMap.this.write();
            this.submap.clear();
        }

        public Set keySet() {
            return new AbstractPersistentCollection.SetProxy(this.submap.keySet());
        }

        public Collection values() {
            return new AbstractPersistentCollection.SetProxy(this.submap.values());
        }

        public Set entrySet() {
            return new PersistentMap.EntrySetProxy(this.submap.entrySet());
        }

        public Comparator comparator() {
            return this.submap.comparator();
        }

        public SortedMap subMap(Object object, Object object2) {
            SortedMap sortedMap = this.submap.subMap(object, object2);
            return new SortedSubMap(sortedMap);
        }

        public SortedMap headMap(Object object) {
            SortedMap sortedMap = this.submap.headMap(object);
            return new SortedSubMap(sortedMap);
        }

        public SortedMap tailMap(Object object) {
            SortedMap sortedMap = this.submap.tailMap(object);
            return new SortedSubMap(sortedMap);
        }

        public Object firstKey() {
            return this.submap.firstKey();
        }

        public Object lastKey() {
            return this.submap.lastKey();
        }
    }
}

