/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.DatasourceConnectionProvider;
import org.hibernate.connection.DriverManagerConnectionProvider;
import org.hibernate.connection.UserSuppliedConnectionProvider;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectionProviderFactory.class);
    private static final Set SPECIAL_PROPERTIES = new HashSet();

    public static ConnectionProvider newConnectionProvider() throws HibernateException {
        return ConnectionProviderFactory.newConnectionProvider(Environment.getProperties());
    }

    public static ConnectionProvider newConnectionProvider(Properties properties) throws HibernateException {
        return ConnectionProviderFactory.newConnectionProvider(properties, null);
    }

    public static ConnectionProvider newConnectionProvider(Properties properties, Map map) throws HibernateException {
        String string = properties.getProperty("hibernate.connection.provider_class");
        ConnectionProvider connectionProvider = string != null ? ConnectionProviderFactory.initializeConnectionProviderFromConfig(string) : (ConnectionProviderFactory.c3p0ConfigDefined(properties) && ConnectionProviderFactory.c3p0ProviderPresent() ? ConnectionProviderFactory.initializeConnectionProviderFromConfig("org.hibernate.connection.C3P0ConnectionProvider") : (properties.getProperty("hibernate.connection.datasource") != null ? new DatasourceConnectionProvider() : (properties.getProperty("hibernate.connection.url") != null ? new DriverManagerConnectionProvider() : new UserSuppliedConnectionProvider())));
        if (map != null && map.size() != 0) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(connectionProvider.getClass());
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                int n = propertyDescriptorArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = propertyDescriptorArray[i].getName();
                    if (!map.containsKey(string2)) continue;
                    Method method = propertyDescriptorArray[i].getWriteMethod();
                    method.invoke((Object)connectionProvider, map.get(string2));
                }
            }
            catch (IntrospectionException introspectionException) {
                throw new HibernateException("Unable to inject objects into the connection provider", introspectionException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new HibernateException("Unable to inject objects into the connection provider", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new HibernateException("Unable to inject objects into the connection provider", invocationTargetException);
            }
        }
        connectionProvider.configure(properties);
        return connectionProvider;
    }

    private static boolean c3p0ProviderPresent() {
        try {
            ReflectHelper.classForName("org.hibernate.connection.C3P0ConnectionProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warn("c3p0 properties is specificed, but could not find org.hibernate.connection.C3P0ConnectionProvider from the classpath, these properties are going to be ignored.");
            return false;
        }
        return true;
    }

    private static boolean c3p0ConfigDefined(Properties properties) {
        for (String string : properties.keySet()) {
            if (!string.startsWith("hibernate.c3p0")) continue;
            return true;
        }
        return false;
    }

    private static ConnectionProvider initializeConnectionProviderFromConfig(String string) {
        ConnectionProvider connectionProvider;
        try {
            log.info("Initializing connection provider: " + string);
            connectionProvider = (ConnectionProvider)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            log.error("Could not instantiate connection provider", exception);
            throw new HibernateException("Could not instantiate connection provider: " + string);
        }
        return connectionProvider;
    }

    private ConnectionProviderFactory() {
        throw new UnsupportedOperationException();
    }

    public static Properties getConnectionProperties(Properties properties) {
        String string;
        Iterator<Object> iterator = properties.keySet().iterator();
        Properties properties2 = new Properties();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!string.startsWith("hibernate.connection") || SPECIAL_PROPERTIES.contains(string)) continue;
            properties2.setProperty(string.substring("hibernate.connection".length() + 1), properties.getProperty(string));
        }
        string = properties.getProperty("hibernate.connection.username");
        if (string != null) {
            properties2.setProperty("user", string);
        }
        return properties2;
    }

    static {
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
    }
}

