/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxoolConnectionProvider
implements ConnectionProvider {
    private static final String PROXOOL_JDBC_STEM = "proxool.";
    private static final Logger log = LoggerFactory.getLogger(ProxoolConnectionProvider.class);
    private String proxoolAlias;
    private boolean existingPool;
    private Integer isolation;
    private boolean autocommit;

    public Connection getConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this.proxoolAlias);
        if (this.isolation != null) {
            connection.setTransactionIsolation(this.isolation);
        }
        if (connection.getAutoCommit() != this.autocommit) {
            connection.setAutoCommit(this.autocommit);
        }
        return connection;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void configure(Properties properties) throws HibernateException {
        String string = properties.getProperty("hibernate.proxool.xml");
        String string2 = properties.getProperty("hibernate.proxool.properties");
        String string3 = properties.getProperty("hibernate.proxool.existing_pool");
        this.proxoolAlias = properties.getProperty("hibernate.proxool.pool_alias");
        if ("true".equals(string3)) {
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String string4 = "Cannot configure Proxool Provider to use an existing in memory pool without the hibernate.proxool.pool_alias property set.";
                log.error(string4);
                throw new HibernateException(string4);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            this.existingPool = true;
            log.info("Configuring Proxool Provider using existing pool in memory: " + this.proxoolAlias);
        } else if (StringHelper.isNotEmpty(string)) {
            log.info("Configuring Proxool Provider using JAXPConfigurator: " + string);
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String string5 = "Cannot configure Proxool Provider to use JAXP without the hibernate.proxool.pool_alias property set.";
                log.error(string5);
                throw new HibernateException(string5);
            }
            try {
                JAXPConfigurator.configure((Reader)ConfigHelper.getConfigStreamReader(string), (boolean)false);
            }
            catch (ProxoolException proxoolException) {
                String string6 = "Proxool Provider unable to load JAXP configurator file: " + string;
                log.error(string6, proxoolException);
                throw new HibernateException(string6, proxoolException);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias);
        } else if (StringHelper.isNotEmpty(string2)) {
            log.info("Configuring Proxool Provider using Properties File: " + string2);
            if (!StringHelper.isNotEmpty(this.proxoolAlias)) {
                String string7 = "Cannot configure Proxool Provider to use Properties File without the hibernate.proxool.pool_alias property set.";
                log.error(string7);
                throw new HibernateException(string7);
            }
            try {
                PropertyConfigurator.configure((Properties)ConfigHelper.getConfigProperties(string2));
            }
            catch (ProxoolException proxoolException) {
                String string8 = "Proxool Provider unable to load load Property configurator file: " + string2;
                log.error(string8, proxoolException);
                throw new HibernateException(string8, proxoolException);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            log.info("Configuring Proxool Provider to use pool alias: " + this.proxoolAlias);
        }
        this.isolation = PropertiesHelper.getInteger("hibernate.connection.isolation", properties);
        if (this.isolation != null) {
            log.info("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation));
        }
        this.autocommit = PropertiesHelper.getBoolean("hibernate.connection.autocommit", properties);
        log.info("autocommit mode: " + this.autocommit);
    }

    public void close() throws HibernateException {
        if (this.existingPool) {
            return;
        }
        try {
            ProxoolFacade.shutdown((int)0);
        }
        catch (Exception exception) {
            log.warn("Exception occured when closing the Proxool pool", exception);
            throw new HibernateException("Exception occured when closing the Proxool pool", exception);
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

