/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;

public class ManagedSessionContext
implements CurrentSessionContext {
    private static final ThreadLocal context = new ThreadLocal();
    private final SessionFactoryImplementor factory;

    public ManagedSessionContext(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }

    public Session currentSession() {
        Session session = ManagedSessionContext.existingSession(this.factory);
        if (session == null) {
            throw new HibernateException("No session currently bound to execution context");
        }
        return session;
    }

    public static boolean hasBind(SessionFactory sessionFactory) {
        return ManagedSessionContext.existingSession(sessionFactory) != null;
    }

    public static Session bind(Session session) {
        return ManagedSessionContext.sessionMap(true).put(session.getSessionFactory(), session);
    }

    public static Session unbind(SessionFactory sessionFactory) {
        Session session = null;
        Map map = ManagedSessionContext.sessionMap();
        if (map != null) {
            session = (Session)map.remove(sessionFactory);
            ManagedSessionContext.doCleanup();
        }
        return session;
    }

    private static Session existingSession(SessionFactory sessionFactory) {
        Map map = ManagedSessionContext.sessionMap();
        if (map == null) {
            return null;
        }
        return (Session)map.get(sessionFactory);
    }

    protected static Map sessionMap() {
        return ManagedSessionContext.sessionMap(false);
    }

    private static synchronized Map sessionMap(boolean bl) {
        HashMap hashMap = (HashMap)context.get();
        if (hashMap == null && bl) {
            hashMap = new HashMap();
            context.set(hashMap);
        }
        return hashMap;
    }

    private static synchronized void doCleanup() {
        Map map = ManagedSessionContext.sessionMap(false);
        if (map != null && map.isEmpty()) {
            context.set(null);
        }
    }
}

