/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.TypedValue;

public class LikeExpression
implements Criterion {
    private final String propertyName;
    private final Object value;
    private final Character escapeChar;
    private final boolean ignoreCase;

    protected LikeExpression(String string, String string2, Character c, boolean bl) {
        this.propertyName = string;
        this.value = string2;
        this.escapeChar = c;
        this.ignoreCase = bl;
    }

    protected LikeExpression(String string, String string2) {
        this(string, string2, null, false);
    }

    protected LikeExpression(String string, String string2, MatchMode matchMode) {
        this(string, matchMode.toMatchString(string2));
    }

    protected LikeExpression(String string, String string2, MatchMode matchMode, Character c, boolean bl) {
        this(string, matchMode.toMatchString(string2), c, bl);
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        Dialect dialect = criteriaQuery.getFactory().getDialect();
        String[] stringArray = criteriaQuery.findColumns(this.propertyName, criteria);
        if (stringArray.length != 1) {
            throw new HibernateException("Like may only be used with single-column properties");
        }
        String string = this.ignoreCase ? dialect.getLowercaseFunction() + '(' + stringArray[0] + ')' : stringArray[0];
        return string + " like ?" + (this.escapeChar == null ? "" : " escape '" + this.escapeChar + "'");
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.propertyName, this.ignoreCase ? this.value.toString().toLowerCase() : this.value.toString())};
    }
}

