/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.type.Type;

public class SimpleExpression
implements Criterion {
    private final String propertyName;
    private final Object value;
    private boolean ignoreCase;
    private final String op;

    protected SimpleExpression(String string, Object object, String string2) {
        this.propertyName = string;
        this.value = object;
        this.op = string2;
    }

    protected SimpleExpression(String string, Object object, String string2, boolean bl) {
        this.propertyName = string;
        this.value = object;
        this.ignoreCase = bl;
        this.op = string2;
    }

    public SimpleExpression ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] stringArray = criteriaQuery.findColumns(this.propertyName, criteria);
        Type type = criteriaQuery.getTypeUsingProjection(criteria, this.propertyName);
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 1) {
            stringBuffer.append('(');
        }
        SessionFactoryImplementor sessionFactoryImplementor = criteriaQuery.getFactory();
        int[] nArray = type.sqlTypes(sessionFactoryImplementor);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = this.ignoreCase && (nArray[i] == 12 || nArray[i] == 1);
            if (bl) {
                stringBuffer.append(sessionFactoryImplementor.getDialect().getLowercaseFunction()).append('(');
            }
            stringBuffer.append(stringArray[i]);
            if (bl) {
                stringBuffer.append(')');
            }
            stringBuffer.append(this.getOp()).append("?");
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(" and ");
        }
        if (stringArray.length > 1) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        Object object = this.ignoreCase ? this.value.toString().toLowerCase() : this.value;
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.propertyName, object)};
    }

    public String toString() {
        return this.propertyName + this.getOp() + this.value;
    }

    protected final String getOp() {
        return this.op;
    }
}

