/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.criteria.CriteriaJoinWalker;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.Type;

public abstract class SubqueryExpression
implements Criterion {
    private CriteriaImpl criteriaImpl;
    private String quantifier;
    private String op;
    private QueryParameters params;
    private Type[] types;
    private CriteriaQueryTranslator innerQuery;

    protected Type[] getTypes() {
        return this.types;
    }

    protected SubqueryExpression(String string, String string2, DetachedCriteria detachedCriteria) {
        this.criteriaImpl = detachedCriteria.getCriteriaImpl();
        this.quantifier = string2;
        this.op = string;
    }

    protected abstract String toLeftSqlString(Criteria var1, CriteriaQuery var2);

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        SessionFactoryImplementor sessionFactoryImplementor = criteriaQuery.getFactory();
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)sessionFactoryImplementor.getEntityPersister(this.criteriaImpl.getEntityOrClassName());
        this.createAndSetInnerQuery(criteriaQuery, sessionFactoryImplementor);
        this.criteriaImpl.setSession(this.deriveRootSession(criteria));
        CriteriaJoinWalker criteriaJoinWalker = new CriteriaJoinWalker(outerJoinLoadable, this.innerQuery, sessionFactoryImplementor, this.criteriaImpl, this.criteriaImpl.getEntityOrClassName(), this.criteriaImpl.getSession().getLoadQueryInfluencers(), this.innerQuery.getRootSQLALias());
        String string = criteriaJoinWalker.getSQLString();
        StringBuffer stringBuffer = new StringBuffer(this.toLeftSqlString(criteria, criteriaQuery));
        if (this.op != null) {
            stringBuffer.append(' ').append(this.op).append(' ');
        }
        if (this.quantifier != null) {
            stringBuffer.append(this.quantifier).append(' ');
        }
        return stringBuffer.append('(').append(string).append(')').toString();
    }

    private SessionImplementor deriveRootSession(Criteria criteria) {
        if (criteria instanceof CriteriaImpl) {
            return ((CriteriaImpl)criteria).getSession();
        }
        if (criteria instanceof CriteriaImpl.Subcriteria) {
            return this.deriveRootSession(((CriteriaImpl.Subcriteria)criteria).getParent());
        }
        return null;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        SessionFactoryImplementor sessionFactoryImplementor = criteriaQuery.getFactory();
        this.createAndSetInnerQuery(criteriaQuery, sessionFactoryImplementor);
        Type[] typeArray = this.params.getPositionalParameterTypes();
        Object[] objectArray = this.params.getPositionalParameterValues();
        TypedValue[] typedValueArray = new TypedValue[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typedValueArray[i] = new TypedValue(typeArray[i], objectArray[i], EntityMode.POJO);
        }
        return typedValueArray;
    }

    private void createAndSetInnerQuery(CriteriaQuery criteriaQuery, SessionFactoryImplementor sessionFactoryImplementor) {
        if (this.innerQuery == null) {
            String string = this.criteriaImpl.getAlias() == null ? criteriaQuery.generateSQLAlias() : this.criteriaImpl.getAlias() + "_";
            this.innerQuery = new CriteriaQueryTranslator(sessionFactoryImplementor, this.criteriaImpl, this.criteriaImpl.getEntityOrClassName(), string, criteriaQuery);
            this.params = this.innerQuery.getQueryParameters();
            this.types = this.innerQuery.getProjectedTypes();
        }
    }
}

