/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Method;
import org.hibernate.MappingException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.function.AnsiTrimFunction;
import org.hibernate.dialect.function.DerbyConcatFunction;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DerbyCaseFragment;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyDialect
extends DB2Dialect {
    private static final Logger log = LoggerFactory.getLogger(DerbyDialect.class);
    private int driverVersionMajor;
    private int driverVersionMinor;

    public DerbyDialect() {
        this.registerFunction("concat", new DerbyConcatFunction());
        this.registerFunction("trim", new AnsiTrimFunction());
        this.determineDriverVersion();
    }

    private void determineDriverVersion() {
        try {
            Class clazz = ReflectHelper.classForName("org.apache.derby.tools.sysinfo", this.getClass());
            Method method = clazz.getMethod("getMajorVersion", ReflectHelper.NO_PARAM_SIGNATURE);
            Method method2 = clazz.getMethod("getMinorVersion", ReflectHelper.NO_PARAM_SIGNATURE);
            this.driverVersionMajor = (Integer)method.invoke(null, ReflectHelper.NO_PARAMS);
            this.driverVersionMinor = (Integer)method2.invoke(null, ReflectHelper.NO_PARAMS);
        }
        catch (Exception exception) {
            log.warn("Unable to load/access derby driver class sysinfo to check versions : " + exception);
            this.driverVersionMajor = -1;
            this.driverVersionMinor = -1;
        }
    }

    private boolean isTenPointFiveReleaseOrNewer() {
        return this.driverVersionMajor > 10 || this.driverVersionMajor == 10 && this.driverVersionMinor >= 5;
    }

    public String getCrossJoinSeparator() {
        return ", ";
    }

    public CaseFragment createCaseFragment() {
        return new DerbyCaseFragment();
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean supportsSequences() {
        return this.driverVersionMajor > 10 || this.driverVersionMajor == 10 && this.driverVersionMinor >= 6;
    }

    public String getSequenceNextValString(String string) {
        if (this.supportsSequences()) {
            return "values next value for " + string;
        }
        throw new MappingException("Derby does not support sequence prior to release 10.6.1.0");
    }

    public boolean supportsLimit() {
        return this.isTenPointFiveReleaseOrNewer();
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return this.isTenPointFiveReleaseOrNewer();
    }

    public String getForUpdateString() {
        return " for update with rs";
    }

    public String getWriteLockString(int n) {
        return " for update with rs";
    }

    public String getReadLockString(int n) {
        return " for read only with rs";
    }

    public String getLimitString(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 50);
        String string2 = string.toLowerCase().trim();
        int n3 = string2.lastIndexOf("for update");
        if (this.hasForUpdateClause(n3)) {
            stringBuffer.append(string.substring(0, n3 - 1));
        } else if (this.hasWithClause(string2)) {
            stringBuffer.append(string.substring(0, this.getWithIndex(string) - 1));
        } else {
            stringBuffer.append(string);
        }
        if (n == 0) {
            stringBuffer.append(" fetch first ");
        } else {
            stringBuffer.append(" offset ").append(n).append(" rows fetch next ");
        }
        stringBuffer.append(n2).append(" rows only");
        if (this.hasForUpdateClause(n3)) {
            stringBuffer.append(' ');
            stringBuffer.append(string.substring(n3));
        } else if (this.hasWithClause(string2)) {
            stringBuffer.append(' ').append(string.substring(this.getWithIndex(string)));
        }
        return stringBuffer.toString();
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    private boolean hasForUpdateClause(int n) {
        return n >= 0;
    }

    private boolean hasWithClause(String string) {
        return string.startsWith("with ", string.length() - 7);
    }

    private int getWithIndex(String string) {
        int n = string.lastIndexOf("with ");
        if (n < 0) {
            n = string.lastIndexOf("WITH ");
        }
        return n;
    }

    public String getQuerySequencesString() {
        return null;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public String getAlterColumnNullableString(String string, boolean bl) {
        return "alter column " + string + (!bl ? " not" : "") + " null";
    }
}

