/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.type.StandardBasicTypes;

public class Ingres9Dialect
extends IngresDialect {
    public Ingres9Dialect() {
        this.registerDateTimeFunctions();
        this.registerDateTimeColumnTypes();
        this.registerFunction("concat", new VarArgsSQLFunction(StandardBasicTypes.STRING, "(", "||", ")"));
    }

    protected void registerDateTimeFunctions() {
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", StandardBasicTypes.DATE, false));
    }

    protected void registerDateTimeColumnTypes() {
        this.registerColumnType(91, "ansidate");
        this.registerColumnType(93, "timestamp(9) with time zone");
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "select last_identity()";
    }

    public String getQuerySequencesString() {
        return "select seq_name from iisequences";
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public String getLimitString(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(" offset " + n);
        StringBuffer stringBuffer2 = new StringBuffer(" fetch first " + n2 + " rows only");
        StringBuffer stringBuffer3 = new StringBuffer(string.length() + stringBuffer.length() + stringBuffer2.length()).append(string);
        if (n > 0) {
            stringBuffer3.append(stringBuffer);
        }
        if (n2 > 0) {
            stringBuffer3.append(stringBuffer2);
        }
        return stringBuffer3.toString();
    }
}

