/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.NvlFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.util.ReflectHelper;

public class Oracle8iDialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            int n = JDBCExceptionHelper.extractErrorCode(sQLException);
            if (n == 1 || n == 2291 || n == 2292) {
                return this.extractUsingTemplate("constraint (", ") violated", sQLException.getMessage());
            }
            if (n == 1400) {
                return null;
            }
            return null;
        }
    };
    public static final String ORACLE_TYPES_CLASS_NAME = "oracle.jdbc.OracleTypes";
    public static final String DEPRECATED_ORACLE_TYPES_CLASS_NAME = "oracle.jdbc.driver.OracleTypes";
    public static final int INIT_ORACLETYPES_CURSOR_VALUE = -99;
    private int oracleCursorTypeSqlType = -99;

    public Oracle8iDialect() {
        this.registerCharacterTypeMappings();
        this.registerNumericTypeMappings();
        this.registerDateTimeTypeMappings();
        this.registerLargeObjectTypeMappings();
        this.registerReverseHibernateTypeMappings();
        this.registerFunctions();
        this.registerDefaultProperties();
    }

    protected void registerCharacterTypeMappings() {
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, 4000, "varchar2($l)");
        this.registerColumnType(12, "long");
    }

    protected void registerNumericTypeMappings() {
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
    }

    protected void registerDateTimeTypeMappings() {
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "date");
    }

    protected void registerLargeObjectTypeMappings() {
        this.registerColumnType(-3, 2000, "raw($l)");
        this.registerColumnType(-3, "long raw");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(-1, "long");
        this.registerColumnType(-4, "long raw");
    }

    protected void registerReverseHibernateTypeMappings() {
    }

    protected void registerFunctions() {
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", StandardBasicTypes.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction("acos", StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", StandardBasicTypes.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", StandardBasicTypes.DOUBLE));
        this.registerFunction("cosh", new StandardSQLFunction("cosh", StandardBasicTypes.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", StandardBasicTypes.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction("ln", StandardBasicTypes.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", StandardBasicTypes.DOUBLE));
        this.registerFunction("sinh", new StandardSQLFunction("sinh", StandardBasicTypes.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction("stddev", StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", StandardBasicTypes.DOUBLE));
        this.registerFunction("tanh", new StandardSQLFunction("tanh", StandardBasicTypes.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction("variance", StandardBasicTypes.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("chr", new StandardSQLFunction("chr", StandardBasicTypes.CHARACTER));
        this.registerFunction("initcap", new StandardSQLFunction("initcap"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("soundex", new StandardSQLFunction("soundex"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", StandardBasicTypes.INTEGER));
        this.registerFunction("to_char", new StandardSQLFunction("to_char", StandardBasicTypes.STRING));
        this.registerFunction("to_date", new StandardSQLFunction("to_date", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", StandardBasicTypes.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_timestamp", StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("last_day", new StandardSQLFunction("last_day", StandardBasicTypes.DATE));
        this.registerFunction("sysdate", new NoArgSQLFunction("sysdate", StandardBasicTypes.DATE, false));
        this.registerFunction("systimestamp", new NoArgSQLFunction("systimestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("uid", new NoArgSQLFunction("uid", StandardBasicTypes.INTEGER, false));
        this.registerFunction("user", new NoArgSQLFunction("user", StandardBasicTypes.STRING, false));
        this.registerFunction("rowid", new NoArgSQLFunction("rowid", StandardBasicTypes.LONG, false));
        this.registerFunction("rownum", new NoArgSQLFunction("rownum", StandardBasicTypes.LONG, false));
        this.registerFunction("concat", new VarArgsSQLFunction(StandardBasicTypes.STRING, "", "||", ""));
        this.registerFunction("instr", new StandardSQLFunction("instr", StandardBasicTypes.INTEGER));
        this.registerFunction("instrb", new StandardSQLFunction("instrb", StandardBasicTypes.INTEGER));
        this.registerFunction("lpad", new StandardSQLFunction("lpad", StandardBasicTypes.STRING));
        this.registerFunction("replace", new StandardSQLFunction("replace", StandardBasicTypes.STRING));
        this.registerFunction("rpad", new StandardSQLFunction("rpad", StandardBasicTypes.STRING));
        this.registerFunction("substr", new StandardSQLFunction("substr", StandardBasicTypes.STRING));
        this.registerFunction("substrb", new StandardSQLFunction("substrb", StandardBasicTypes.STRING));
        this.registerFunction("translate", new StandardSQLFunction("translate", StandardBasicTypes.STRING));
        this.registerFunction("substring", new StandardSQLFunction("substr", StandardBasicTypes.STRING));
        this.registerFunction("locate", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "instr(?2,?1)"));
        this.registerFunction("bit_length", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "vsize(?1)*8"));
        this.registerFunction("coalesce", new NvlFunction());
        this.registerFunction("atan2", new StandardSQLFunction("atan2", StandardBasicTypes.FLOAT));
        this.registerFunction("log", new StandardSQLFunction("log", StandardBasicTypes.INTEGER));
        this.registerFunction("mod", new StandardSQLFunction("mod", StandardBasicTypes.INTEGER));
        this.registerFunction("nvl", new StandardSQLFunction("nvl"));
        this.registerFunction("nvl2", new StandardSQLFunction("nvl2"));
        this.registerFunction("power", new StandardSQLFunction("power", StandardBasicTypes.FLOAT));
        this.registerFunction("add_months", new StandardSQLFunction("add_months", StandardBasicTypes.DATE));
        this.registerFunction("months_between", new StandardSQLFunction("months_between", StandardBasicTypes.FLOAT));
        this.registerFunction("next_day", new StandardSQLFunction("next_day", StandardBasicTypes.DATE));
        this.registerFunction("str", new StandardSQLFunction("to_char", StandardBasicTypes.STRING));
    }

    protected void registerDefaultProperties() {
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
    }

    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    public String getCrossJoinSeparator() {
        return ", ";
    }

    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    public String getLimitString(String string, boolean bl) {
        string = string.trim();
        boolean bl2 = false;
        if (string.toLowerCase().endsWith(" for update")) {
            string = string.substring(0, string.length() - 11);
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        if (bl) {
            stringBuffer.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            stringBuffer.append("select * from ( ");
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
        } else {
            stringBuffer.append(" ) where rownum <= ?");
        }
        if (bl2) {
            stringBuffer.append(" for update");
        }
        return stringBuffer.toString();
    }

    public String getBasicSelectClauseNullString(int n) {
        return super.getSelectClauseNullString(n);
    }

    public String getSelectClauseNullString(int n) {
        switch (n) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }

    public String getCurrentTimestampSelectString() {
        return "select sysdate from dual";
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "sysdate";
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getSequenceNextValString(String string) {
        return "select " + this.getSelectSequenceNextValString(string) + " from dual";
    }

    public String getSelectSequenceNextValString(String string) {
        return string + ".nextval";
    }

    public String getCreateSequenceString(String string) {
        return "create sequence " + string;
    }

    public String getDropSequenceString(String string) {
        return "drop sequence " + string;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getForUpdateString(String string) {
        return this.getForUpdateString() + " of " + string;
    }

    public String getForUpdateNowaitString(String string) {
        return this.getForUpdateString() + " of " + string + " nowait";
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public String getQuerySequencesString() {
        return " select sequence_name from all_sequences  union select synonym_name   from all_synonyms us, all_sequences asq  where asq.sequence_name = us.table_name    and asq.sequence_owner = us.table_owner";
    }

    public String getSelectGUIDString() {
        return "select rawtohex(sys_guid()) from dual";
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public int getOracleCursorTypeSqlType() {
        if (this.oracleCursorTypeSqlType == -99) {
            this.oracleCursorTypeSqlType = this.extractOracleCursorTypeValue();
        }
        return this.oracleCursorTypeSqlType;
    }

    protected int extractOracleCursorTypeValue() {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(ORACLE_TYPES_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = ReflectHelper.classForName(DEPRECATED_ORACLE_TYPES_CLASS_NAME);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                throw new HibernateException("Unable to locate OracleTypes class", classNotFoundException2);
            }
        }
        try {
            return clazz.getField("CURSOR").getInt(null);
        }
        catch (Exception exception) {
            throw new HibernateException("Unable to access OracleTypes.CURSOR value", exception);
        }
    }

    public int registerResultSetOutParameter(CallableStatement callableStatement, int n) throws SQLException {
        callableStatement.registerOutParameter(n, this.getOracleCursorTypeSqlType());
        return ++n;
    }

    public ResultSet getResultSet(CallableStatement callableStatement) throws SQLException {
        callableStatement.execute();
        return (ResultSet)callableStatement.getObject(1);
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String string) {
        String string2 = super.generateTemporaryTableName(string);
        return string2.length() > 30 ? string2.substring(1, 30) : string2;
    }

    public String getCreateTemporaryTableString() {
        return "create global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "on commit delete rows";
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public String getCreateTableInTablespaceKeyword() {
        return "tablespace";
    }

    public boolean supportPrimaryKeyTablespace() {
        return true;
    }

    public String getAlterColumnDefinitionString(String string, String string2) {
        return "modify " + string + " " + string2;
    }
}

