/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.NvlFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oracle9Dialect
extends Dialect {
    private static final Logger log = LoggerFactory.getLogger(Oracle9Dialect.class);
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            int n = JDBCExceptionHelper.extractErrorCode(sQLException);
            if (n == 1 || n == 2291 || n == 2292) {
                return this.extractUsingTemplate("constraint (", ") violated", sQLException.getMessage());
            }
            if (n == 1400) {
                return null;
            }
            return null;
        }
    };
    int oracletypes_cursor_value = 0;

    public Oracle9Dialect() {
        log.warn("The Oracle9Dialect dialect has been deprecated; use either Oracle9iDialect or Oracle10gDialect instead");
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(1, "char(1 char)");
        this.registerColumnType(12, 4000, "varchar2($l char)");
        this.registerColumnType(12, "long");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, 2000, "raw($l)");
        this.registerColumnType(-3, "long raw");
        this.registerColumnType(2, "number($p,$s)");
        this.registerColumnType(3, "number($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", StandardBasicTypes.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction("acos", StandardBasicTypes.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", StandardBasicTypes.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", StandardBasicTypes.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", StandardBasicTypes.DOUBLE));
        this.registerFunction("cosh", new StandardSQLFunction("cosh", StandardBasicTypes.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", StandardBasicTypes.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction("ln", StandardBasicTypes.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", StandardBasicTypes.DOUBLE));
        this.registerFunction("sinh", new StandardSQLFunction("sinh", StandardBasicTypes.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction("stddev", StandardBasicTypes.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", StandardBasicTypes.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", StandardBasicTypes.DOUBLE));
        this.registerFunction("tanh", new StandardSQLFunction("tanh", StandardBasicTypes.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction("variance", StandardBasicTypes.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("chr", new StandardSQLFunction("chr", StandardBasicTypes.CHARACTER));
        this.registerFunction("initcap", new StandardSQLFunction("initcap"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("soundex", new StandardSQLFunction("soundex"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", StandardBasicTypes.INTEGER));
        this.registerFunction("to_char", new StandardSQLFunction("to_char", StandardBasicTypes.STRING));
        this.registerFunction("to_date", new StandardSQLFunction("to_date", StandardBasicTypes.TIMESTAMP));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", StandardBasicTypes.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_timestamp", StandardBasicTypes.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("last_day", new StandardSQLFunction("last_day", StandardBasicTypes.DATE));
        this.registerFunction("sysdate", new NoArgSQLFunction("sysdate", StandardBasicTypes.DATE, false));
        this.registerFunction("systimestamp", new NoArgSQLFunction("systimestamp", StandardBasicTypes.TIMESTAMP, false));
        this.registerFunction("uid", new NoArgSQLFunction("uid", StandardBasicTypes.INTEGER, false));
        this.registerFunction("user", new NoArgSQLFunction("user", StandardBasicTypes.STRING, false));
        this.registerFunction("rowid", new NoArgSQLFunction("rowid", StandardBasicTypes.LONG, false));
        this.registerFunction("rownum", new NoArgSQLFunction("rownum", StandardBasicTypes.LONG, false));
        this.registerFunction("concat", new VarArgsSQLFunction(StandardBasicTypes.STRING, "", "||", ""));
        this.registerFunction("instr", new StandardSQLFunction("instr", StandardBasicTypes.INTEGER));
        this.registerFunction("instrb", new StandardSQLFunction("instrb", StandardBasicTypes.INTEGER));
        this.registerFunction("lpad", new StandardSQLFunction("lpad", StandardBasicTypes.STRING));
        this.registerFunction("replace", new StandardSQLFunction("replace", StandardBasicTypes.STRING));
        this.registerFunction("rpad", new StandardSQLFunction("rpad", StandardBasicTypes.STRING));
        this.registerFunction("substr", new StandardSQLFunction("substr", StandardBasicTypes.STRING));
        this.registerFunction("substrb", new StandardSQLFunction("substrb", StandardBasicTypes.STRING));
        this.registerFunction("translate", new StandardSQLFunction("translate", StandardBasicTypes.STRING));
        this.registerFunction("substring", new StandardSQLFunction("substr", StandardBasicTypes.STRING));
        this.registerFunction("locate", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "instr(?2,?1)"));
        this.registerFunction("bit_length", new SQLFunctionTemplate(StandardBasicTypes.INTEGER, "vsize(?1)*8"));
        this.registerFunction("coalesce", new NvlFunction());
        this.registerFunction("atan2", new StandardSQLFunction("atan2", StandardBasicTypes.FLOAT));
        this.registerFunction("log", new StandardSQLFunction("log", StandardBasicTypes.INTEGER));
        this.registerFunction("mod", new StandardSQLFunction("mod", StandardBasicTypes.INTEGER));
        this.registerFunction("nvl", new StandardSQLFunction("nvl"));
        this.registerFunction("nvl2", new StandardSQLFunction("nvl2"));
        this.registerFunction("power", new StandardSQLFunction("power", StandardBasicTypes.FLOAT));
        this.registerFunction("add_months", new StandardSQLFunction("add_months", StandardBasicTypes.DATE));
        this.registerFunction("months_between", new StandardSQLFunction("months_between", StandardBasicTypes.FLOAT));
        this.registerFunction("next_day", new StandardSQLFunction("next_day", StandardBasicTypes.DATE));
        this.registerFunction("str", new StandardSQLFunction("to_char", StandardBasicTypes.STRING));
        this.registerFunction("rawtohex", new StandardSQLFunction("rawtohex", StandardBasicTypes.STRING));
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getDropColumnString() {
        return "drop column";
    }

    public String getSequenceNextValString(String string) {
        return "select " + this.getSelectSequenceNextValString(string) + " from dual";
    }

    public String getSelectSequenceNextValString(String string) {
        return string + ".nextval";
    }

    public String getCreateSequenceString(String string) {
        return "create sequence " + string;
    }

    public String getDropSequenceString(String string) {
        return "drop sequence " + string;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getForUpdateNowaitString() {
        return " for update nowait";
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String string, boolean bl) {
        string = string.trim();
        boolean bl2 = false;
        if (string.toLowerCase().endsWith(" for update")) {
            string = string.substring(0, string.length() - 11);
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        if (bl) {
            stringBuffer.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            stringBuffer.append("select * from ( ");
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        } else {
            stringBuffer.append(" ) where rownum <= ?");
        }
        if (bl2) {
            stringBuffer.append(" for update");
        }
        return stringBuffer.toString();
    }

    public String getForUpdateString(String string) {
        return this.getForUpdateString() + " of " + string;
    }

    public String getForUpdateNowaitString(String string) {
        return this.getForUpdateString() + " of " + string + " nowait";
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public String getQuerySequencesString() {
        return "select sequence_name from user_sequences";
    }

    public String getSelectGUIDString() {
        return "select rawtohex(sys_guid()) from dual";
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public int registerResultSetOutParameter(CallableStatement callableStatement, int n) throws SQLException {
        if (this.oracletypes_cursor_value == 0) {
            try {
                Class clazz = ReflectHelper.classForName("oracle.jdbc.driver.OracleTypes");
                this.oracletypes_cursor_value = clazz.getField("CURSOR").getInt(clazz.newInstance());
            }
            catch (Exception exception) {
                throw new HibernateException("Problem while trying to load or access OracleTypes.CURSOR value", exception);
            }
        }
        callableStatement.registerOutParameter(n, this.oracletypes_cursor_value);
        return ++n;
    }

    public ResultSet getResultSet(CallableStatement callableStatement) throws SQLException {
        callableStatement.execute();
        return (ResultSet)callableStatement.getObject(1);
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String string) {
        String string2 = super.generateTemporaryTableName(string);
        return string2.length() > 30 ? string2.substring(1, 30) : string2;
    }

    public String getCreateTemporaryTableString() {
        return "create global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "on commit delete rows";
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select systimestamp from dual";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExistsInSelect() {
        return false;
    }

    public String getAlterColumnDefaultValueString(String string, String string2) {
        return "modify " + string + " default " + string2;
    }

    public String getAlterColumnDefinitionString(String string, String string2) {
        return "modify " + string + " " + string2;
    }

    public String getReferenceOnUpdateDeleteString(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            return " on delete " + string2;
        }
        return "";
    }

    public String getCreateTableInTablespaceKeyword() {
        return "tablespace";
    }

    public boolean supportPrimaryKeyTablespace() {
        return true;
    }
}

