/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.sql.ANSICaseFragment;
import org.hibernate.sql.CaseFragment;

public class Oracle9iDialect
extends Oracle8iDialect {
    protected void registerCharacterTypeMappings() {
        this.registerColumnType(1, "char(1 char)");
        this.registerColumnType(12, 4000, "varchar2($l char)");
        this.registerColumnType(12, "long");
    }

    protected void registerDateTimeTypeMappings() {
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "timestamp");
    }

    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    public String getLimitString(String string, boolean bl) {
        string = string.trim();
        String string2 = null;
        boolean bl2 = false;
        int n = string.toLowerCase().lastIndexOf("for update");
        if (n > -1) {
            string2 = string.substring(n);
            string = string.substring(0, n - 1);
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        if (bl) {
            stringBuffer.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            stringBuffer.append("select * from ( ");
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        } else {
            stringBuffer.append(" ) where rownum <= ?");
        }
        if (bl2) {
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getSelectClauseNullString(int n) {
        return this.getBasicSelectClauseNullString(n);
    }

    public String getCurrentTimestampSelectString() {
        return "select systimestamp from dual";
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getWriteLockString(int n) {
        if (n == 0) {
            return " for update nowait";
        }
        if (n > 0) {
            float f = (float)n / 1000.0f;
            n = Math.round(f);
            return " for update wait " + n;
        }
        return " for update";
    }

    public String getReadLockString(int n) {
        return this.getWriteLockString(n);
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }
}

