/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDialect
extends Oracle9Dialect {
    private static final Logger log = LoggerFactory.getLogger(OracleDialect.class);

    public OracleDialect() {
        log.warn("The OracleDialect dialect has been deprecated; use Oracle8iDialect instead");
        this.registerColumnType(93, "date");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, 4000, "varchar2($l)");
    }

    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    public String getLimitString(String string, boolean bl) {
        string = string.trim();
        boolean bl2 = false;
        if (string.toLowerCase().endsWith(" for update")) {
            string = string.substring(0, string.length() - 11);
            bl2 = true;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 100);
        if (bl) {
            stringBuffer.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            stringBuffer.append("select * from ( ");
        }
        stringBuffer.append(string);
        if (bl) {
            stringBuffer.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
        } else {
            stringBuffer.append(" ) where rownum <= ?");
        }
        if (bl2) {
            stringBuffer.append(" for update");
        }
        return stringBuffer.toString();
    }

    public String getSelectClauseNullString(int n) {
        switch (n) {
            case 1: 
            case 12: {
                return "to_char(null)";
            }
            case 91: 
            case 92: 
            case 93: {
                return "to_date(null)";
            }
        }
        return "to_number(null)";
    }

    public String getCurrentTimestampSelectString() {
        return "select sysdate from dual";
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "sysdate";
    }
}

