/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class CastFunction
implements SQLFunction {
    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Type getReturnType(Type type, Mapping mapping) throws QueryException {
        return type;
    }

    public String render(Type type, List list, SessionFactoryImplementor sessionFactoryImplementor) throws QueryException {
        if (list.size() != 2) {
            throw new QueryException("cast() requires two arguments");
        }
        String string = (String)list.get(1);
        int[] nArray = sessionFactoryImplementor.getTypeResolver().heuristicType(string).sqlTypes(sessionFactoryImplementor);
        if (nArray.length != 1) {
            throw new QueryException("invalid Hibernate type for cast()");
        }
        String string2 = sessionFactoryImplementor.getDialect().getCastTypeName(nArray[0]);
        if (string2 == null) {
            string2 = string;
        }
        return "cast(" + list.get(0) + " as " + string2 + ')';
    }
}

