/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class NoArgSQLFunction
implements SQLFunction {
    private Type returnType;
    private boolean hasParenthesesIfNoArguments;
    private String name;

    public NoArgSQLFunction(String string, Type type) {
        this(string, type, true);
    }

    public NoArgSQLFunction(String string, Type type, boolean bl) {
        this.returnType = type;
        this.hasParenthesesIfNoArguments = bl;
        this.name = string;
    }

    public boolean hasArguments() {
        return false;
    }

    public boolean hasParenthesesIfNoArguments() {
        return this.hasParenthesesIfNoArguments;
    }

    public Type getReturnType(Type type, Mapping mapping) throws QueryException {
        return this.returnType;
    }

    public String render(Type type, List list, SessionFactoryImplementor sessionFactoryImplementor) throws QueryException {
        if (list.size() > 0) {
            throw new QueryException("function takes no arguments: " + this.name);
        }
        return this.hasParenthesesIfNoArguments ? this.name + "()" : this.name;
    }
}

