/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public abstract class TrimFunctionTemplate
implements SQLFunction {
    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return false;
    }

    public Type getReturnType(Type type, Mapping mapping) throws QueryException {
        return StandardBasicTypes.STRING;
    }

    public String render(Type type, List list, SessionFactoryImplementor sessionFactoryImplementor) throws QueryException {
        String string;
        Options options = new Options();
        if (list.size() == 1) {
            string = (String)list.get(0);
        } else if ("from".equalsIgnoreCase((String)list.get(0))) {
            string = (String)list.get(1);
        } else {
            int n = 1;
            String string2 = (String)list.get(0);
            if ("leading".equalsIgnoreCase(string2)) {
                options.setTrimSpecification(Specification.LEADING);
            } else if ("trailing".equalsIgnoreCase(string2)) {
                options.setTrimSpecification(Specification.TRAILING);
            } else if (!"both".equalsIgnoreCase(string2)) {
                n = 0;
            }
            String string3 = (String)list.get(n);
            if ("from".equalsIgnoreCase(string3)) {
                string = (String)list.get(n + 1);
            } else if (n + 1 >= list.size()) {
                string = string3;
            } else {
                options.setTrimCharacter(string3);
                string = "from".equalsIgnoreCase((String)list.get(n + 1)) ? (String)list.get(n + 2) : (String)list.get(n + 1);
            }
        }
        return this.render(options, string, sessionFactoryImplementor);
    }

    protected abstract String render(Options var1, String var2, SessionFactoryImplementor var3);

    public static class Specification {
        public static final Specification LEADING = new Specification("leading");
        public static final Specification TRAILING = new Specification("trailing");
        public static final Specification BOTH = new Specification("both");
        private final String name;

        private Specification(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Options {
        public static final String DEFAULT_TRIM_CHARACTER = "' '";
        private String trimCharacter = "' '";
        private Specification trimSpecification = Specification.BOTH;

        public String getTrimCharacter() {
            return this.trimCharacter;
        }

        public void setTrimCharacter(String string) {
            this.trimCharacter = string;
        }

        public Specification getTrimSpecification() {
            return this.trimSpecification;
        }

        public void setTrimSpecification(Specification specification) {
            this.trimSpecification = specification;
        }
    }
}

