/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.action.EntityIncrementVersionProcess;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.persister.entity.Lockable;

public class OptimisticForceIncrementLockingStrategy
implements LockingStrategy {
    private final Lockable lockable;
    private final LockMode lockMode;

    public OptimisticForceIncrementLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.OPTIMISTIC_FORCE_INCREMENT)) {
            throw new HibernateException("[" + lockMode + "] not valid for [" + lockable.getEntityName() + "]");
        }
    }

    public void lock(Serializable serializable, Object object, Object object2, int n, SessionImplementor sessionImplementor) throws StaleObjectStateException, JDBCException {
        if (!this.lockable.isVersioned()) {
            throw new HibernateException("[" + this.lockMode + "] not supported for non-versioned entities [" + this.lockable.getEntityName() + "]");
        }
        EntityEntry entityEntry = sessionImplementor.getPersistenceContext().getEntry(object2);
        EntityIncrementVersionProcess entityIncrementVersionProcess = new EntityIncrementVersionProcess(object2, entityEntry);
        EventSource eventSource = (EventSource)sessionImplementor;
        eventSource.getActionQueue().registerProcess(entityIncrementVersionProcess);
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

