/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PessimisticLockException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.AbstractSelectLockingStrategy;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;

public class PessimisticWriteSelectLockingStrategy
extends AbstractSelectLockingStrategy {
    public PessimisticWriteSelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        super(lockable, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable serializable, Object object, Object object2, int n, SessionImplementor sessionImplementor) throws StaleObjectStateException, JDBCException {
        String string = this.determineSql(n);
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(string);
            try {
                this.getLockable().getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                if (this.getLockable().isVersioned()) {
                    this.getLockable().getVersionType().nullSafeSet(preparedStatement, object, this.getLockable().getIdentifierType().getColumnSpan(sessionFactoryImplementor) + 1, sessionImplementor);
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (!resultSet.next()) {
                        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                            sessionFactoryImplementor.getStatisticsImplementor().optimisticFailure(this.getLockable().getEntityName());
                        }
                        throw new StaleObjectStateException(this.getLockable().getEntityName(), serializable);
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            JDBCException jDBCException = JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not lock: " + MessageHelper.infoString((EntityPersister)this.getLockable(), serializable, sessionImplementor.getFactory()), string);
            throw new PessimisticLockException("could not obtain pessimistic lock", jDBCException, object2);
        }
    }

    protected String generateLockString(int n) {
        SessionFactoryImplementor sessionFactoryImplementor = this.getLockable().getFactory();
        LockOptions lockOptions = new LockOptions(this.getLockMode());
        lockOptions.setTimeOut(n);
        SimpleSelect simpleSelect = new SimpleSelect(sessionFactoryImplementor.getDialect()).setLockOptions(lockOptions).setTableName(this.getLockable().getRootTableName()).addColumn(this.getLockable().getRootTableIdentifierColumnNames()[0]).addCondition(this.getLockable().getRootTableIdentifierColumnNames(), "=?");
        if (this.getLockable().isVersioned()) {
            simpleSelect.addCondition(this.getLockable().getVersionColumnName(), "=?");
        }
        if (sessionFactoryImplementor.getSettings().isCommentsEnabled()) {
            simpleSelect.setComment(this.getLockMode() + " lock " + this.getLockable().getEntityName());
        }
        return simpleSelect.toStatementString();
    }
}

