/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.BasicSQLExceptionConverter;
import org.hibernate.dialect.resolver.DialectResolver;
import org.hibernate.exception.JDBCConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDialectResolver
implements DialectResolver {
    private static final Logger log = LoggerFactory.getLogger(AbstractDialectResolver.class);

    public final Dialect resolveDialect(DatabaseMetaData databaseMetaData) {
        try {
            return this.resolveDialectInternal(databaseMetaData);
        }
        catch (SQLException sQLException) {
            JDBCException jDBCException = BasicSQLExceptionConverter.INSTANCE.convert(sQLException);
            if (jDBCException instanceof JDBCConnectionException) {
                throw jDBCException;
            }
            log.warn("Unable to query java.sql.DatabaseMetaData : " + sQLException.getMessage());
            return null;
        }
        catch (Throwable throwable) {
            log.warn("Error executing resolver [" + this + "] : " + throwable.getMessage());
            return null;
        }
    }

    protected abstract Dialect resolveDialectInternal(DatabaseMetaData var1) throws SQLException;
}

