/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectResolver;
import org.hibernate.dialect.resolver.DialectResolverSet;
import org.hibernate.dialect.resolver.StandardDialectResolver;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectFactory {
    private static final Logger log = LoggerFactory.getLogger(DialectFactory.class);
    private static DialectResolverSet DIALECT_RESOLVERS = new DialectResolverSet();

    static void registerDialectResolver(String string) {
        try {
            DialectResolver dialectResolver = (DialectResolver)ReflectHelper.classForName(string).newInstance();
            DIALECT_RESOLVERS.addResolverAtFirst(dialectResolver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warn("Dialect resolver class not found: " + string);
        }
        catch (Exception exception) {
            log.warn("Could not instantiate dialect resolver class", exception);
        }
    }

    public static Dialect buildDialect(Properties properties, Connection connection) throws HibernateException {
        String string = properties.getProperty("hibernate.dialect");
        if (string == null) {
            return DialectFactory.determineDialect(connection);
        }
        return DialectFactory.constructDialect(string);
    }

    public static Dialect buildDialect(Properties properties) {
        String string = properties.getProperty("hibernate.dialect");
        if (string == null) {
            throw new HibernateException("'hibernate.dialect' must be set when no Connection available");
        }
        return DialectFactory.constructDialect(string);
    }

    private static Dialect determineDialect(Connection connection) {
        if (connection == null) {
            throw new HibernateException("Connection cannot be null when 'hibernate.dialect' not set");
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Dialect dialect = DIALECT_RESOLVERS.resolveDialect(databaseMetaData);
            if (dialect == null) {
                throw new HibernateException("Unable to determine Dialect to use [name=" + databaseMetaData.getDatabaseProductName() + ", majorVersion=" + databaseMetaData.getDatabaseMajorVersion() + "]; user must register resolver or explicitly set 'hibernate.dialect'");
            }
            return dialect;
        }
        catch (SQLException sQLException) {
            throw new HibernateException("Unable to access java.sql.DatabaseMetaData to determine appropriate Dialect to use", sQLException);
        }
    }

    public static Dialect constructDialect(String string) {
        try {
            return (Dialect)ReflectHelper.classForName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Dialect class not found: " + string, classNotFoundException);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not instantiate dialect class", exception);
        }
    }

    static {
        DIALECT_RESOLVERS.addResolver(new StandardDialectResolver());
        String string = Environment.getProperties().getProperty("hibernate.dialect_resolvers");
        if (string != null) {
            String[] stringArray = string.split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                DialectFactory.registerDialectResolver(stringArray[i]);
            }
        }
    }
}

