/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectResolver;
import org.hibernate.exception.JDBCConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialectResolverSet
implements DialectResolver {
    private static Logger log = LoggerFactory.getLogger(DialectResolverSet.class);
    private List resolvers = new ArrayList();

    public Dialect resolveDialect(DatabaseMetaData databaseMetaData) {
        for (DialectResolver dialectResolver : this.resolvers) {
            try {
                Dialect dialect = dialectResolver.resolveDialect(databaseMetaData);
                if (dialect == null) continue;
                return dialect;
            }
            catch (JDBCConnectionException jDBCConnectionException) {
                throw jDBCConnectionException;
            }
            catch (Throwable throwable) {
                log.info("sub-resolver threw unexpected exception, continuing to next : " + throwable.getMessage());
            }
        }
        return null;
    }

    public void addResolver(DialectResolver dialectResolver) {
        this.resolvers.add(dialectResolver);
    }

    public void addResolverAtFirst(DialectResolver dialectResolver) {
        this.resolvers.add(0, dialectResolver);
    }
}

