/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.resolver;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.DerbyDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.Ingres10Dialect;
import org.hibernate.dialect.Ingres9Dialect;
import org.hibernate.dialect.IngresDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle10gDialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.Oracle9iDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseASE15Dialect;
import org.hibernate.dialect.SybaseAnywhereDialect;
import org.hibernate.dialect.resolver.AbstractDialectResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardDialectResolver
extends AbstractDialectResolver {
    private static final Logger log = LoggerFactory.getLogger(StandardDialectResolver.class);

    protected Dialect resolveDialectInternal(DatabaseMetaData databaseMetaData) throws SQLException {
        String string = databaseMetaData.getDatabaseProductName();
        int n = databaseMetaData.getDatabaseMajorVersion();
        if ("HSQL Database Engine".equals(string)) {
            return new HSQLDialect();
        }
        if ("H2".equals(string)) {
            return new H2Dialect();
        }
        if ("MySQL".equals(string)) {
            return new MySQLDialect();
        }
        if ("PostgreSQL".equals(string)) {
            return new PostgreSQLDialect();
        }
        if ("Apache Derby".equals(string)) {
            return new DerbyDialect();
        }
        if ("ingres".equalsIgnoreCase(string)) {
            switch (n) {
                case 9: {
                    int n2 = databaseMetaData.getDatabaseMinorVersion();
                    if (n2 > 2) {
                        return new Ingres9Dialect();
                    }
                    return new IngresDialect();
                }
                case 10: {
                    log.warn("Ingres " + n + " is not yet fully supported; using Ingres 9.3 dialect");
                    return new Ingres10Dialect();
                }
            }
            log.warn("Unknown Ingres major version [" + n + "] using Ingres 9.2 dialect");
            return new IngresDialect();
        }
        if (string.startsWith("Microsoft SQL Server")) {
            return new SQLServerDialect();
        }
        if ("Sybase SQL Server".equals(string) || "Adaptive Server Enterprise".equals(string)) {
            return new SybaseASE15Dialect();
        }
        if (string.startsWith("Adaptive Server Anywhere")) {
            return new SybaseAnywhereDialect();
        }
        if ("Informix Dynamic Server".equals(string)) {
            return new InformixDialect();
        }
        if (string.startsWith("DB2/")) {
            return new DB2Dialect();
        }
        if ("Oracle".equals(string)) {
            switch (n) {
                case 11: {
                    log.warn("Oracle 11g is not yet fully supported; using 10g dialect");
                    return new Oracle10gDialect();
                }
                case 10: {
                    return new Oracle10gDialect();
                }
                case 9: {
                    return new Oracle9iDialect();
                }
                case 8: {
                    return new Oracle8iDialect();
                }
            }
            log.warn("unknown Oracle major version [" + n + "]");
        }
        return null;
    }
}

