/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.action.EntityAction;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.action.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionQueue {
    private static final Logger log = LoggerFactory.getLogger(ActionQueue.class);
    private static final int INIT_QUEUE_LIST_SIZE = 5;
    private SessionImplementor session;
    private ArrayList insertions;
    private ArrayList deletions;
    private ArrayList updates;
    private ArrayList collectionCreations;
    private ArrayList collectionUpdates;
    private ArrayList collectionRemovals;
    private AfterTransactionCompletionProcessQueue afterTransactionProcesses;
    private BeforeTransactionCompletionProcessQueue beforeTransactionProcesses;

    public ActionQueue(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
        this.init();
    }

    private void init() {
        this.insertions = new ArrayList(5);
        this.deletions = new ArrayList(5);
        this.updates = new ArrayList(5);
        this.collectionCreations = new ArrayList(5);
        this.collectionRemovals = new ArrayList(5);
        this.collectionUpdates = new ArrayList(5);
        this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(this.session);
        this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(this.session);
    }

    public void clear() {
        this.updates.clear();
        this.insertions.clear();
        this.deletions.clear();
        this.collectionCreations.clear();
        this.collectionRemovals.clear();
        this.collectionUpdates.clear();
    }

    public void addAction(EntityInsertAction entityInsertAction) {
        this.insertions.add(entityInsertAction);
    }

    public void addAction(EntityDeleteAction entityDeleteAction) {
        this.deletions.add(entityDeleteAction);
    }

    public void addAction(EntityUpdateAction entityUpdateAction) {
        this.updates.add(entityUpdateAction);
    }

    public void addAction(CollectionRecreateAction collectionRecreateAction) {
        this.collectionCreations.add(collectionRecreateAction);
    }

    public void addAction(CollectionRemoveAction collectionRemoveAction) {
        this.collectionRemovals.add(collectionRemoveAction);
    }

    public void addAction(CollectionUpdateAction collectionUpdateAction) {
        this.collectionUpdates.add(collectionUpdateAction);
    }

    public void addAction(EntityIdentityInsertAction entityIdentityInsertAction) {
        this.insertions.add(entityIdentityInsertAction);
    }

    public void addAction(BulkOperationCleanupAction bulkOperationCleanupAction) {
        this.registerCleanupActions(bulkOperationCleanupAction);
    }

    public void registerProcess(AfterTransactionCompletionProcess afterTransactionCompletionProcess) {
        this.afterTransactionProcesses.register(afterTransactionCompletionProcess);
    }

    public void registerProcess(BeforeTransactionCompletionProcess beforeTransactionCompletionProcess) {
        this.beforeTransactionProcesses.register(beforeTransactionCompletionProcess);
    }

    public void executeInserts() throws HibernateException {
        this.executeActions(this.insertions);
    }

    public void executeActions() throws HibernateException {
        this.executeActions(this.insertions);
        this.executeActions(this.updates);
        this.executeActions(this.collectionRemovals);
        this.executeActions(this.collectionUpdates);
        this.executeActions(this.collectionCreations);
        this.executeActions(this.deletions);
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
    }

    public void afterTransactionCompletion(boolean bl) {
        this.afterTransactionProcesses.afterTransactionCompletion(bl);
    }

    public void beforeTransactionCompletion() {
        this.beforeTransactionProcesses.beforeTransactionCompletion();
    }

    public boolean areTablesToBeUpdated(Set set) {
        return ActionQueue.areTablesToUpdated(this.updates, set) || ActionQueue.areTablesToUpdated(this.insertions, set) || ActionQueue.areTablesToUpdated(this.deletions, set) || ActionQueue.areTablesToUpdated(this.collectionUpdates, set) || ActionQueue.areTablesToUpdated(this.collectionCreations, set) || ActionQueue.areTablesToUpdated(this.collectionRemovals, set);
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return this.insertions.size() > 0 || this.deletions.size() > 0;
    }

    private static boolean areTablesToUpdated(List list, Set set) {
        for (Executable executable : list) {
            Serializable[] serializableArray;
            for (Serializable serializable : serializableArray = executable.getPropertySpaces()) {
                if (!set.contains(serializable)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("changes must be flushed to space: " + serializable);
                }
                return true;
            }
        }
        return false;
    }

    private void executeActions(List list) throws HibernateException {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.execute((Executable)list.get(i));
        }
        list.clear();
        this.session.getBatcher().executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Executable executable) {
        try {
            executable.execute();
        }
        finally {
            this.registerCleanupActions(executable);
        }
    }

    private void registerCleanupActions(Executable executable) {
        this.beforeTransactionProcesses.register(executable.getBeforeTransactionCompletionProcess());
        if (this.session.getFactory().getSettings().isQueryCacheEnabled()) {
            String[] stringArray = (String[])executable.getPropertySpaces();
            this.afterTransactionProcesses.addSpacesToInvalidate(stringArray);
            this.session.getFactory().getUpdateTimestampsCache().preinvalidate((Serializable[])stringArray);
        }
        this.afterTransactionProcesses.register(executable.getAfterTransactionCompletionProcess());
    }

    private void prepareActions(List list) throws HibernateException {
        for (Executable executable : list) {
            executable.beforeExecutions();
        }
    }

    public String toString() {
        return new StringBuffer().append("ActionQueue[insertions=").append(this.insertions).append(" updates=").append(this.updates).append(" deletions=").append(this.deletions).append(" collectionCreations=").append(this.collectionCreations).append(" collectionRemovals=").append(this.collectionRemovals).append(" collectionUpdates=").append(this.collectionUpdates).append("]").toString();
    }

    public int numberOfCollectionRemovals() {
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        return this.deletions.size();
    }

    public int numberOfUpdates() {
        return this.updates.size();
    }

    public int numberOfInsertions() {
        return this.insertions.size();
    }

    public void sortCollectionActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.collectionCreations);
            Collections.sort(this.collectionUpdates);
            Collections.sort(this.collectionRemovals);
        }
    }

    public void sortActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            Collections.sort(this.updates);
        }
        if (this.session.getFactory().getSettings().isOrderInsertsEnabled()) {
            this.sortInsertActions();
        }
    }

    private void sortInsertActions() {
        new InsertActionSorter().sort();
    }

    public ArrayList cloneDeletions() {
        return (ArrayList)this.deletions.clone();
    }

    public void clearFromFlushNeededCheck(int n) {
        this.collectionCreations.clear();
        this.collectionUpdates.clear();
        this.updates.clear();
        for (int i = this.collectionRemovals.size() - 1; i >= n; --i) {
            this.collectionRemovals.remove(i);
        }
    }

    public boolean hasAfterTransactionActions() {
        return this.afterTransactionProcesses.processes.size() > 0;
    }

    public boolean hasBeforeTransactionActions() {
        return this.beforeTransactionProcesses.processes.size() > 0;
    }

    public boolean hasAnyQueuedActions() {
        return this.updates.size() > 0 || this.insertions.size() > 0 || this.deletions.size() > 0 || this.collectionUpdates.size() > 0 || this.collectionRemovals.size() > 0 || this.collectionCreations.size() > 0;
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        log.trace("serializing action-queue");
        int n2 = this.insertions.size();
        log.trace("starting serialization of [" + n2 + "] insertions entries");
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.insertions.get(n));
        }
        n2 = this.deletions.size();
        log.trace("starting serialization of [" + n2 + "] deletions entries");
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.deletions.get(n));
        }
        n2 = this.updates.size();
        log.trace("starting serialization of [" + n2 + "] updates entries");
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.updates.get(n));
        }
        n2 = this.collectionUpdates.size();
        log.trace("starting serialization of [" + n2 + "] collectionUpdates entries");
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionUpdates.get(n));
        }
        n2 = this.collectionRemovals.size();
        log.trace("starting serialization of [" + n2 + "] collectionRemovals entries");
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionRemovals.get(n));
        }
        n2 = this.collectionCreations.size();
        log.trace("starting serialization of [" + n2 + "] collectionCreations entries");
        objectOutputStream.writeInt(n2);
        for (n = 0; n < n2; ++n) {
            objectOutputStream.writeObject(this.collectionCreations.get(n));
        }
    }

    public static ActionQueue deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        int n;
        log.trace("deserializing action-queue");
        ActionQueue actionQueue = new ActionQueue(sessionImplementor);
        int n2 = objectInputStream.readInt();
        log.trace("starting deserialization of [" + n2 + "] insertions entries");
        actionQueue.insertions = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.insertions.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace("starting deserialization of [" + n2 + "] deletions entries");
        actionQueue.deletions = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.deletions.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace("starting deserialization of [" + n2 + "] updates entries");
        actionQueue.updates = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.updates.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace("starting deserialization of [" + n2 + "] collectionUpdates entries");
        actionQueue.collectionUpdates = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.collectionUpdates.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace("starting deserialization of [" + n2 + "] collectionRemovals entries");
        actionQueue.collectionRemovals = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.collectionRemovals.add(objectInputStream.readObject());
        }
        n2 = objectInputStream.readInt();
        log.trace("starting deserialization of [" + n2 + "] collectionCreations entries");
        actionQueue.collectionCreations = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            actionQueue.collectionCreations.add(objectInputStream.readObject());
        }
        return actionQueue;
    }

    private class InsertActionSorter {
        private HashMap latestBatches = new HashMap();
        private HashMap entityBatchNumber;
        private HashMap actionBatches = new HashMap();

        public InsertActionSorter() {
            this.entityBatchNumber = new HashMap(ActionQueue.this.insertions.size() + 1, 1.0f);
        }

        public void sort() {
            Comparable<Integer> comparable;
            Object object;
            Object object2;
            for (Object object3 : ActionQueue.this.insertions) {
                object2 = ((EntityAction)object3).getEntityName();
                object = ((EntityAction)object3).getInstance();
                if (this.latestBatches.containsKey(object2)) {
                    comparable = this.findBatchNumber((EntityInsertAction)object3, (String)object2);
                } else {
                    comparable = this.actionBatches.size();
                    this.latestBatches.put(object2, comparable);
                }
                this.entityBatchNumber.put(object, comparable);
                this.addToBatch((Integer)comparable, (EntityInsertAction)object3);
            }
            ActionQueue.this.insertions.clear();
            for (int i = 0; i < this.actionBatches.size(); ++i) {
                Object object3;
                object3 = (List)this.actionBatches.get(new Integer(i));
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    comparable = (EntityInsertAction)object;
                    ActionQueue.this.insertions.add(comparable);
                }
            }
        }

        private Integer findBatchNumber(EntityInsertAction entityInsertAction, String string) {
            Integer n = (Integer)this.latestBatches.get(string);
            Object[] objectArray = entityInsertAction.getState();
            Type[] typeArray = entityInsertAction.getPersister().getClassMetadata().getPropertyTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                Integer n2;
                Object object = objectArray[i];
                Type type = typeArray[i];
                if (!type.isEntityType() || object == null || (n2 = (Integer)this.entityBatchNumber.get(object)) == null || n2.compareTo(n) <= 0) continue;
                n = this.actionBatches.size();
                this.latestBatches.put(string, n);
                break;
            }
            return n;
        }

        private void addToBatch(Integer n, EntityInsertAction entityInsertAction) {
            LinkedList<EntityInsertAction> linkedList = (LinkedList<EntityInsertAction>)this.actionBatches.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<EntityInsertAction>();
                this.actionBatches.put(n, linkedList);
            }
            linkedList.add(entityInsertAction);
        }
    }

    private static class AfterTransactionCompletionProcessQueue {
        private SessionImplementor session;
        private Set<String> querySpacesToInvalidate = new HashSet<String>();
        private List<AfterTransactionCompletionProcess> processes = new ArrayList<AfterTransactionCompletionProcess>(15);

        private AfterTransactionCompletionProcessQueue(SessionImplementor sessionImplementor) {
            this.session = sessionImplementor;
        }

        public void addSpacesToInvalidate(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.addSpaceToInvalidate(stringArray[i]);
            }
        }

        public void addSpaceToInvalidate(String string) {
            this.querySpacesToInvalidate.add(string);
        }

        public void register(AfterTransactionCompletionProcess afterTransactionCompletionProcess) {
            if (afterTransactionCompletionProcess == null) {
                return;
            }
            this.processes.add(afterTransactionCompletionProcess);
        }

        public void afterTransactionCompletion(boolean bl) {
            int n = this.processes.size();
            for (int i = 0; i < n; ++i) {
                try {
                    AfterTransactionCompletionProcess afterTransactionCompletionProcess = this.processes.get(i);
                    afterTransactionCompletionProcess.doAfterTransactionCompletion(bl, this.session);
                    continue;
                }
                catch (CacheException cacheException) {
                    log.error("could not release a cache lock", cacheException);
                    continue;
                }
                catch (Exception exception) {
                    throw new AssertionFailure("Exception releasing cache locks", exception);
                }
            }
            this.processes.clear();
            if (this.session.getFactory().getSettings().isQueryCacheEnabled()) {
                this.session.getFactory().getUpdateTimestampsCache().invalidate((Serializable[])this.querySpacesToInvalidate.toArray(new String[this.querySpacesToInvalidate.size()]));
            }
            this.querySpacesToInvalidate.clear();
        }
    }

    private static class BeforeTransactionCompletionProcessQueue {
        private SessionImplementor session;
        private List<BeforeTransactionCompletionProcess> processes = new ArrayList<BeforeTransactionCompletionProcess>();

        private BeforeTransactionCompletionProcessQueue(SessionImplementor sessionImplementor) {
            this.session = sessionImplementor;
        }

        public void register(BeforeTransactionCompletionProcess beforeTransactionCompletionProcess) {
            if (beforeTransactionCompletionProcess == null) {
                return;
            }
            this.processes.add(beforeTransactionCompletionProcess);
        }

        public void beforeTransactionCompletion() {
            int n = this.processes.size();
            for (int i = 0; i < n; ++i) {
                try {
                    BeforeTransactionCompletionProcess beforeTransactionCompletionProcess = this.processes.get(i);
                    beforeTransactionCompletionProcess.doBeforeTransactionCompletion(this.session);
                    continue;
                }
                catch (HibernateException hibernateException) {
                    throw hibernateException;
                }
                catch (Exception exception) {
                    throw new AssertionFailure("Unable to perform beforeTransactionCompletion callback", exception);
                }
            }
            this.processes.clear();
        }
    }
}

