/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.cache.CacheKey;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.util.MarkerObject;

public class BatchFetchQueue {
    public static final Object MARKER = new MarkerObject("MARKER");
    private final Map batchLoadableEntityKeys = new LinkedHashMap(8);
    private final Map subselectsByEntityKey = new HashMap(8);
    private final PersistenceContext context;

    public BatchFetchQueue(PersistenceContext persistenceContext) {
        this.context = persistenceContext;
    }

    public void clear() {
        this.batchLoadableEntityKeys.clear();
        this.subselectsByEntityKey.clear();
    }

    public SubselectFetch getSubselect(EntityKey entityKey) {
        return (SubselectFetch)this.subselectsByEntityKey.get(entityKey);
    }

    public void addSubselect(EntityKey entityKey, SubselectFetch subselectFetch) {
        this.subselectsByEntityKey.put(entityKey, subselectFetch);
    }

    public void removeSubselect(EntityKey entityKey) {
        this.subselectsByEntityKey.remove(entityKey);
    }

    public void clearSubselects() {
        this.subselectsByEntityKey.clear();
    }

    public void addBatchLoadableEntityKey(EntityKey entityKey) {
        if (entityKey.isBatchLoadable()) {
            this.batchLoadableEntityKeys.put(entityKey, MARKER);
        }
    }

    public void removeBatchLoadableEntityKey(EntityKey entityKey) {
        if (entityKey.isBatchLoadable()) {
            this.batchLoadableEntityKeys.remove(entityKey);
        }
    }

    public Serializable[] getCollectionBatch(CollectionPersister collectionPersister, Serializable serializable, int n, EntityMode entityMode) {
        Serializable[] serializableArray = new Serializable[n];
        serializableArray[0] = serializable;
        int n2 = 1;
        int n3 = -1;
        boolean bl = false;
        for (Map.Entry entry : this.context.getCollectionEntries().entrySet()) {
            CollectionEntry collectionEntry = (CollectionEntry)entry.getValue();
            PersistentCollection persistentCollection = (PersistentCollection)entry.getKey();
            if (persistentCollection.wasInitialized() || collectionEntry.getLoadedPersister() != collectionPersister) continue;
            if (bl && n2 == n3) {
                return serializableArray;
            }
            boolean bl2 = collectionPersister.getKeyType().isEqual(serializable, collectionEntry.getLoadedKey(), entityMode, collectionPersister.getFactory());
            if (bl2) {
                n3 = n2;
            } else if (!this.isCached(collectionEntry.getLoadedKey(), collectionPersister, entityMode)) {
                serializableArray[n2++] = collectionEntry.getLoadedKey();
            }
            if (n2 != n) continue;
            n2 = 1;
            if (n3 == -1) continue;
            bl = true;
        }
        return serializableArray;
    }

    public Serializable[] getEntityBatch(EntityPersister entityPersister, Serializable serializable, int n, EntityMode entityMode) {
        Serializable[] serializableArray = new Serializable[n];
        serializableArray[0] = serializable;
        int n2 = 1;
        int n3 = -1;
        boolean bl = false;
        for (EntityKey entityKey : this.batchLoadableEntityKeys.keySet()) {
            if (!entityKey.getEntityName().equals(entityPersister.getEntityName())) continue;
            if (bl && n2 == n3) {
                return serializableArray;
            }
            if (entityPersister.getIdentifierType().isEqual(serializable, entityKey.getIdentifier(), entityMode)) {
                n3 = n2;
            } else if (!this.isCached(entityKey, entityPersister, entityMode)) {
                serializableArray[n2++] = entityKey.getIdentifier();
            }
            if (n2 != n) continue;
            n2 = 1;
            if (n3 == -1) continue;
            bl = true;
        }
        return serializableArray;
    }

    private boolean isCached(EntityKey entityKey, EntityPersister entityPersister, EntityMode entityMode) {
        if (entityPersister.hasCache()) {
            CacheKey cacheKey = new CacheKey(entityKey.getIdentifier(), entityPersister.getIdentifierType(), entityKey.getEntityName(), entityMode, this.context.getSession().getFactory());
            return entityPersister.getCacheAccessStrategy().get(cacheKey, this.context.getSession().getTimestamp()) != null;
        }
        return false;
    }

    private boolean isCached(Serializable serializable, CollectionPersister collectionPersister, EntityMode entityMode) {
        if (collectionPersister.hasCache()) {
            CacheKey cacheKey = new CacheKey(serializable, collectionPersister.getKeyType(), collectionPersister.getRole(), entityMode, this.context.getSession().getFactory());
            return collectionPersister.getCacheAccessStrategy().get(cacheKey, this.context.getSession().getTimestamp()) != null;
        }
        return false;
    }
}

