/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadingAction;
import org.hibernate.util.ArrayHelper;

public abstract class CascadeStyle
implements Serializable {
    public static final CascadeStyle ALL_DELETE_ORPHAN = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return true;
        }

        public boolean hasOrphanDelete() {
            return true;
        }

        public String toString() {
            return "STYLE_ALL_DELETE_ORPHAN";
        }
    };
    public static final CascadeStyle ALL = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return true;
        }

        public String toString() {
            return "STYLE_ALL";
        }
    };
    public static final CascadeStyle UPDATE = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.SAVE_UPDATE || cascadingAction == CascadingAction.SAVE_UPDATE_COPY;
        }

        public String toString() {
            return "STYLE_SAVE_UPDATE";
        }
    };
    public static final CascadeStyle LOCK = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.LOCK;
        }

        public String toString() {
            return "STYLE_LOCK";
        }
    };
    public static final CascadeStyle REFRESH = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.REFRESH;
        }

        public String toString() {
            return "STYLE_REFRESH";
        }
    };
    public static final CascadeStyle EVICT = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.EVICT;
        }

        public String toString() {
            return "STYLE_EVICT";
        }
    };
    public static final CascadeStyle REPLICATE = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.REPLICATE;
        }

        public String toString() {
            return "STYLE_REPLICATE";
        }
    };
    public static final CascadeStyle MERGE = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.MERGE;
        }

        public String toString() {
            return "STYLE_MERGE";
        }
    };
    public static final CascadeStyle PERSIST = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.PERSIST || cascadingAction == CascadingAction.PERSIST_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_PERSIST";
        }
    };
    public static final CascadeStyle DELETE = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.DELETE;
        }

        public String toString() {
            return "STYLE_DELETE";
        }
    };
    public static final CascadeStyle DELETE_ORPHAN = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.DELETE || cascadingAction == CascadingAction.SAVE_UPDATE;
        }

        public boolean reallyDoCascade(CascadingAction cascadingAction) {
            return cascadingAction == CascadingAction.DELETE;
        }

        public boolean hasOrphanDelete() {
            return true;
        }

        public String toString() {
            return "STYLE_DELETE_ORPHAN";
        }
    };
    public static final CascadeStyle NONE = new CascadeStyle(){

        public boolean doCascade(CascadingAction cascadingAction) {
            return false;
        }

        public String toString() {
            return "STYLE_NONE";
        }
    };
    static final Map STYLES = new HashMap();

    public abstract boolean doCascade(CascadingAction var1);

    public boolean reallyDoCascade(CascadingAction cascadingAction) {
        return this.doCascade(cascadingAction);
    }

    public boolean hasOrphanDelete() {
        return false;
    }

    CascadeStyle() {
    }

    public static CascadeStyle getCascadeStyle(String string) {
        CascadeStyle cascadeStyle = (CascadeStyle)STYLES.get(string);
        if (cascadeStyle == null) {
            throw new MappingException("Unsupported cascade style: " + string);
        }
        return cascadeStyle;
    }

    static {
        STYLES.put("all", ALL);
        STYLES.put("all-delete-orphan", ALL_DELETE_ORPHAN);
        STYLES.put("save-update", UPDATE);
        STYLES.put("persist", PERSIST);
        STYLES.put("merge", MERGE);
        STYLES.put("lock", LOCK);
        STYLES.put("refresh", REFRESH);
        STYLES.put("replicate", REPLICATE);
        STYLES.put("evict", EVICT);
        STYLES.put("delete", DELETE);
        STYLES.put("remove", DELETE);
        STYLES.put("delete-orphan", DELETE_ORPHAN);
        STYLES.put("none", NONE);
    }

    public static final class MultipleCascadeStyle
    extends CascadeStyle {
        private final CascadeStyle[] styles;

        public MultipleCascadeStyle(CascadeStyle[] cascadeStyleArray) {
            this.styles = cascadeStyleArray;
        }

        public boolean doCascade(CascadingAction cascadingAction) {
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].doCascade(cascadingAction)) continue;
                return true;
            }
            return false;
        }

        public boolean reallyDoCascade(CascadingAction cascadingAction) {
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].reallyDoCascade(cascadingAction)) continue;
                return true;
            }
            return false;
        }

        public boolean hasOrphanDelete() {
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].hasOrphanDelete()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return ArrayHelper.toString(this.styles);
        }
    }
}

