/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;

public final class CollectionKey
implements Serializable {
    private final String role;
    private final Serializable key;
    private final Type keyType;
    private final SessionFactoryImplementor factory;
    private final int hashCode;
    private EntityMode entityMode;

    public CollectionKey(CollectionPersister collectionPersister, Serializable serializable, EntityMode entityMode) {
        this(collectionPersister.getRole(), serializable, collectionPersister.getKeyType(), entityMode, collectionPersister.getFactory());
    }

    private CollectionKey(String string, Serializable serializable, Type type, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        this.role = string;
        this.key = serializable;
        this.keyType = type;
        this.entityMode = entityMode;
        this.factory = sessionFactoryImplementor;
        this.hashCode = this.generateHashCode();
    }

    public boolean equals(Object object) {
        CollectionKey collectionKey = (CollectionKey)object;
        return collectionKey.role.equals(this.role) && this.keyType.isEqual(collectionKey.key, this.key, this.entityMode, this.factory);
    }

    public int generateHashCode() {
        int n = 17;
        n = 37 * n + this.role.hashCode();
        n = 37 * n + this.keyType.getHashCode(this.key, this.entityMode, this.factory);
        return n;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getRole() {
        return this.role;
    }

    public Serializable getKey() {
        return this.key;
    }

    public String toString() {
        return "CollectionKey" + MessageHelper.collectionInfoString(this.factory.getCollectionPersister(this.role), this.key, this.factory);
    }

    void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.role);
        objectOutputStream.writeObject(this.key);
        objectOutputStream.writeObject(this.keyType);
        objectOutputStream.writeObject(this.entityMode.toString());
    }

    static CollectionKey deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        return new CollectionKey((String)objectInputStream.readObject(), (Serializable)objectInputStream.readObject(), (Type)objectInputStream.readObject(), EntityMode.parse((String)objectInputStream.readObject()), sessionImplementor == null ? null : sessionImplementor.getFactory());
    }
}

