/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class ExecuteUpdateResultCheckStyle
implements Serializable {
    public static final ExecuteUpdateResultCheckStyle NONE = new ExecuteUpdateResultCheckStyle("none");
    public static final ExecuteUpdateResultCheckStyle COUNT = new ExecuteUpdateResultCheckStyle("rowcount");
    public static final ExecuteUpdateResultCheckStyle PARAM = new ExecuteUpdateResultCheckStyle("param");
    private final String name;

    private ExecuteUpdateResultCheckStyle(String string) {
        this.name = string;
    }

    private Object readResolve() throws ObjectStreamException {
        ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle = ExecuteUpdateResultCheckStyle.parse(this.name);
        if (executeUpdateResultCheckStyle == null) {
            throw new InvalidObjectException("unknown result style [" + this.name + "]");
        }
        return executeUpdateResultCheckStyle;
    }

    public static ExecuteUpdateResultCheckStyle parse(String string) {
        if (string.equals(ExecuteUpdateResultCheckStyle.NONE.name)) {
            return NONE;
        }
        if (string.equals(ExecuteUpdateResultCheckStyle.COUNT.name)) {
            return COUNT;
        }
        if (string.equals(ExecuteUpdateResultCheckStyle.PARAM.name)) {
            return PARAM;
        }
        return null;
    }

    public static ExecuteUpdateResultCheckStyle determineDefault(String string, boolean bl) {
        if (string == null) {
            return COUNT;
        }
        return bl ? PARAM : COUNT;
    }
}

