/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.engine.JoinHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.QueryJoinFragment;
import org.hibernate.type.AssociationType;
import org.hibernate.util.CollectionHelper;

public class JoinSequence {
    private final SessionFactoryImplementor factory;
    private final List joins = new ArrayList();
    private boolean useThetaStyle = false;
    private final StringBuffer conditions = new StringBuffer();
    private String rootAlias;
    private Joinable rootJoinable;
    private Selector selector;
    private JoinSequence next;
    private boolean isFromPart = false;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JoinSequence{");
        if (this.rootJoinable != null) {
            stringBuffer.append(this.rootJoinable).append('[').append(this.rootAlias).append(']');
        }
        for (int i = 0; i < this.joins.size(); ++i) {
            stringBuffer.append("->").append(this.joins.get(i));
        }
        return stringBuffer.append('}').toString();
    }

    public JoinSequence(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }

    public JoinSequence getFromPart() {
        JoinSequence joinSequence = new JoinSequence(this.factory);
        joinSequence.joins.addAll(this.joins);
        joinSequence.useThetaStyle = this.useThetaStyle;
        joinSequence.rootAlias = this.rootAlias;
        joinSequence.rootJoinable = this.rootJoinable;
        joinSequence.selector = this.selector;
        joinSequence.next = this.next == null ? null : this.next.getFromPart();
        joinSequence.isFromPart = true;
        return joinSequence;
    }

    public JoinSequence copy() {
        JoinSequence joinSequence = new JoinSequence(this.factory);
        joinSequence.joins.addAll(this.joins);
        joinSequence.useThetaStyle = this.useThetaStyle;
        joinSequence.rootAlias = this.rootAlias;
        joinSequence.rootJoinable = this.rootJoinable;
        joinSequence.selector = this.selector;
        joinSequence.next = this.next == null ? null : this.next.copy();
        joinSequence.isFromPart = this.isFromPart;
        joinSequence.conditions.append(this.conditions.toString());
        return joinSequence;
    }

    public JoinSequence addJoin(AssociationType associationType, String string, int n, String[] stringArray) throws MappingException {
        this.joins.add(new Join(associationType, string, n, stringArray));
        return this;
    }

    public JoinFragment toJoinFragment() throws MappingException {
        return this.toJoinFragment(CollectionHelper.EMPTY_MAP, true);
    }

    public JoinFragment toJoinFragment(Map map, boolean bl) throws MappingException {
        return this.toJoinFragment(map, bl, null, null);
    }

    public JoinFragment toJoinFragment(Map map, boolean bl, String string, String string2) throws MappingException {
        Object object;
        QueryJoinFragment queryJoinFragment = new QueryJoinFragment(this.factory.getDialect(), this.useThetaStyle);
        if (this.rootJoinable != null) {
            queryJoinFragment.addCrossJoin(this.rootJoinable.getTableName(), this.rootAlias);
            object = this.rootJoinable.filterFragment(this.rootAlias, map);
            queryJoinFragment.setHasFilterCondition(queryJoinFragment.addCondition((String)object));
            if (bl) {
                this.addExtraJoins(queryJoinFragment, this.rootAlias, this.rootJoinable, true);
            }
        }
        object = this.rootJoinable;
        for (int i = 0; i < this.joins.size(); ++i) {
            String string3;
            Join join = (Join)this.joins.get(i);
            String string4 = join.getAssociationType().getOnCondition(join.getAlias(), this.factory, map);
            String string5 = null;
            string5 = object != null && this.isManyToManyRoot((Joinable)object) && ((QueryableCollection)object).getElementType() == join.getAssociationType() ? ("".equals(string3 = ((QueryableCollection)object).getManyToManyFilterFragment(join.getAlias(), map)) ? string4 : ("".equals(string4) ? string3 : string4 + " and " + string3)) : string4;
            if (string != null && join.getAlias().equals(string2)) {
                string5 = string5 + " and " + string;
            }
            queryJoinFragment.addJoin(join.getJoinable().getTableName(), join.getAlias(), join.getLHSColumns(), JoinHelper.getRHSColumnNames(join.getAssociationType(), this.factory), join.joinType, string5);
            if (bl) {
                this.addExtraJoins(queryJoinFragment, join.getAlias(), join.getJoinable(), join.joinType == 0);
            }
            object = join.getJoinable();
        }
        if (this.next != null) {
            queryJoinFragment.addFragment(this.next.toJoinFragment(map, bl));
        }
        queryJoinFragment.addCondition(this.conditions.toString());
        if (this.isFromPart) {
            queryJoinFragment.clearWherePart();
        }
        return queryJoinFragment;
    }

    private boolean isManyToManyRoot(Joinable joinable) {
        if (joinable != null && joinable.isCollection()) {
            QueryableCollection queryableCollection = (QueryableCollection)joinable;
            return queryableCollection.isManyToMany();
        }
        return false;
    }

    private boolean isIncluded(String string) {
        return this.selector != null && this.selector.includeSubclasses(string);
    }

    private void addExtraJoins(JoinFragment joinFragment, String string, Joinable joinable, boolean bl) {
        boolean bl2 = this.isIncluded(string);
        joinFragment.addJoins(joinable.fromJoinFragment(string, bl, bl2), joinable.whereJoinFragment(string, bl, bl2));
    }

    public JoinSequence addCondition(String string) {
        if (string.trim().length() != 0) {
            if (!string.startsWith(" and ")) {
                this.conditions.append(" and ");
            }
            this.conditions.append(string);
        }
        return this;
    }

    public JoinSequence addCondition(String string, String[] stringArray, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.conditions.append(" and ").append(string).append('.').append(stringArray[i]).append(string2);
        }
        return this;
    }

    public JoinSequence setRoot(Joinable joinable, String string) {
        this.rootAlias = string;
        this.rootJoinable = joinable;
        return this;
    }

    public JoinSequence setNext(JoinSequence joinSequence) {
        this.next = joinSequence;
        return this;
    }

    public JoinSequence setSelector(Selector selector) {
        this.selector = selector;
        return this;
    }

    public JoinSequence setUseThetaStyle(boolean bl) {
        this.useThetaStyle = bl;
        return this;
    }

    public boolean isThetaStyle() {
        return this.useThetaStyle;
    }

    public int getJoinCount() {
        return this.joins.size();
    }

    public Iterator iterateJoins() {
        return this.joins.iterator();
    }

    public Join getFirstJoin() {
        return (Join)this.joins.get(0);
    }

    public static interface Selector {
        public boolean includeSubclasses(String var1);
    }

    public final class Join {
        private final AssociationType associationType;
        private final Joinable joinable;
        private final int joinType;
        private final String alias;
        private final String[] lhsColumns;

        Join(AssociationType associationType, String string, int n, String[] stringArray) throws MappingException {
            this.associationType = associationType;
            this.joinable = associationType.getAssociatedJoinable(JoinSequence.this.factory);
            this.alias = string;
            this.joinType = n;
            this.lhsColumns = stringArray;
        }

        public String getAlias() {
            return this.alias;
        }

        public AssociationType getAssociationType() {
            return this.associationType;
        }

        public Joinable getJoinable() {
            return this.joinable;
        }

        public int getJoinType() {
            return this.joinType;
        }

        public String[] getLHSColumns() {
            return this.lhsColumns;
        }

        public String toString() {
            return this.joinable.toString() + '[' + this.alias + ']';
        }
    }
}

