/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.Filter;
import org.hibernate.UnknownProfileException;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.impl.FilterImpl;
import org.hibernate.type.Type;

public class LoadQueryInfluencers
implements Serializable {
    public static LoadQueryInfluencers NONE = new LoadQueryInfluencers();
    private final SessionFactoryImplementor sessionFactory;
    private String internalFetchProfile;
    private Map enabledFilters;
    private Set enabledFetchProfileNames;

    public LoadQueryInfluencers() {
        this(null, Collections.EMPTY_MAP, Collections.EMPTY_SET);
    }

    public LoadQueryInfluencers(SessionFactoryImplementor sessionFactoryImplementor) {
        this(sessionFactoryImplementor, new HashMap(), new HashSet());
    }

    private LoadQueryInfluencers(SessionFactoryImplementor sessionFactoryImplementor, Map map, Set set) {
        this.sessionFactory = sessionFactoryImplementor;
        this.enabledFilters = map;
        this.enabledFetchProfileNames = set;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public String getInternalFetchProfile() {
        return this.internalFetchProfile;
    }

    public void setInternalFetchProfile(String string) {
        if (this.sessionFactory == null) {
            throw new IllegalStateException("Cannot modify context-less LoadQueryInfluencers");
        }
        this.internalFetchProfile = string;
    }

    public boolean hasEnabledFilters() {
        return this.enabledFilters != null && !this.enabledFilters.isEmpty();
    }

    public Map getEnabledFilters() {
        for (Filter filter : this.enabledFilters.values()) {
            filter.validate();
        }
        return this.enabledFilters;
    }

    public Set getEnabledFilterNames() {
        return Collections.unmodifiableSet(this.enabledFilters.keySet());
    }

    public Filter getEnabledFilter(String string) {
        return (Filter)this.enabledFilters.get(string);
    }

    public Filter enableFilter(String string) {
        FilterImpl filterImpl = new FilterImpl(this.sessionFactory.getFilterDefinition(string));
        this.enabledFilters.put(string, filterImpl);
        return filterImpl;
    }

    public void disableFilter(String string) {
        this.enabledFilters.remove(string);
    }

    public Object getFilterParameterValue(String string) {
        String[] stringArray = LoadQueryInfluencers.parseFilterParameterName(string);
        FilterImpl filterImpl = (FilterImpl)this.enabledFilters.get(stringArray[0]);
        if (filterImpl == null) {
            throw new IllegalArgumentException("Filter [" + stringArray[0] + "] currently not enabled");
        }
        return filterImpl.getParameter(stringArray[1]);
    }

    public Type getFilterParameterType(String string) {
        String[] stringArray = LoadQueryInfluencers.parseFilterParameterName(string);
        FilterDefinition filterDefinition = this.sessionFactory.getFilterDefinition(stringArray[0]);
        if (filterDefinition == null) {
            throw new IllegalArgumentException("Filter [" + stringArray[0] + "] not defined");
        }
        Type type = filterDefinition.getParameterType(stringArray[1]);
        if (type == null) {
            throw new InternalError("Unable to locate type for filter parameter");
        }
        return type;
    }

    public static String[] parseFilterParameterName(String string) {
        int n = string.indexOf(46);
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid filter-parameter name format");
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return new String[]{string2, string3};
    }

    public boolean hasEnabledFetchProfiles() {
        return this.enabledFetchProfileNames != null && !this.enabledFetchProfileNames.isEmpty();
    }

    public Set getEnabledFetchProfileNames() {
        return this.enabledFetchProfileNames;
    }

    private void checkFetchProfileName(String string) {
        if (!this.sessionFactory.containsFetchProfileDefinition(string)) {
            throw new UnknownProfileException(string);
        }
    }

    public boolean isFetchProfileEnabled(String string) throws UnknownProfileException {
        this.checkFetchProfileName(string);
        return this.enabledFetchProfileNames.contains(string);
    }

    public void enableFetchProfile(String string) throws UnknownProfileException {
        this.checkFetchProfileName(string);
        this.enabledFetchProfileNames.add(string);
    }

    public void disableFetchProfile(String string) throws UnknownProfileException {
        this.checkFetchProfileName(string);
        this.enabledFetchProfileNames.remove(string);
    }
}

