/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterBinder {
    private static final Logger log = LoggerFactory.getLogger(ParameterBinder.class);

    private ParameterBinder() {
    }

    public static int bindQueryParameters(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, NamedParameterSource namedParameterSource, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        int n2 = n;
        n2 += ParameterBinder.bindPositionalParameters(preparedStatement, queryParameters, n2, sessionImplementor);
        n2 += ParameterBinder.bindNamedParameters(preparedStatement, queryParameters, n2, namedParameterSource, sessionImplementor);
        return n2;
    }

    public static int bindPositionalParameters(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return ParameterBinder.bindPositionalParameters(preparedStatement, queryParameters.getPositionalParameterValues(), queryParameters.getPositionalParameterTypes(), n, sessionImplementor);
    }

    public static int bindPositionalParameters(PreparedStatement preparedStatement, Object[] objectArray, Type[] typeArray, int n, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            typeArray[i].nullSafeSet(preparedStatement, objectArray[i], n + n2, sessionImplementor);
            n2 += typeArray[i].getColumnSpan(sessionImplementor.getFactory());
        }
        return n2;
    }

    public static int bindNamedParameters(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, NamedParameterSource namedParameterSource, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        return ParameterBinder.bindNamedParameters(preparedStatement, queryParameters.getNamedParameters(), n, namedParameterSource, sessionImplementor);
    }

    public static int bindNamedParameters(PreparedStatement preparedStatement, Map map, int n, NamedParameterSource namedParameterSource, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                TypedValue typedValue = (TypedValue)entry.getValue();
                int[] nArray = namedParameterSource.getNamedParameterLocations(string);
                for (int i = 0; i < nArray.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug("bindNamedParameters() " + typedValue.getValue() + " -> " + string + " [" + (nArray[i] + n) + "]");
                    }
                    typedValue.getType().nullSafeSet(preparedStatement, typedValue.getValue(), nArray[i] + n, sessionImplementor);
                }
                n2 += nArray.length;
            }
            return n2;
        }
        return 0;
    }

    public static interface NamedParameterSource {
        public int[] getNamedParameterLocations(String var1);
    }
}

