/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Map;
import java.util.Set;
import org.hibernate.engine.QueryParameters;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.util.StringHelper;

public class SubselectFetch {
    private final Set resultingEntityKeys;
    private final String queryString;
    private final String alias;
    private final Loadable loadable;
    private final QueryParameters queryParameters;
    private final Map namedParameterLocMap;

    public SubselectFetch(String string, Loadable loadable, QueryParameters queryParameters, Set set, Map map) {
        this.resultingEntityKeys = set;
        this.queryParameters = queryParameters;
        this.namedParameterLocMap = map;
        this.loadable = loadable;
        this.alias = string;
        String string2 = queryParameters.getFilteredSQL();
        int n = string2.indexOf(" from ");
        int n2 = string2.lastIndexOf("order by");
        this.queryString = n2 > 0 ? string2.substring(n, n2) : string2.substring(n);
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public Set getResult() {
        return this.resultingEntityKeys;
    }

    public String toSubselectString(String string) {
        String[] stringArray = string == null ? StringHelper.qualify(this.alias, this.loadable.getIdentifierColumnNames()) : ((PropertyMapping)((Object)this.loadable)).toColumns(this.alias, string);
        return new StringBuffer().append("select ").append(StringHelper.join(", ", stringArray)).append(this.queryString).toString();
    }

    public String toString() {
        return "SubselectFetch(" + this.queryString + ')';
    }

    public Map getNamedParameterLocMap() {
        return this.namedParameterLocMap;
    }
}

