/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwoPhaseLoad {
    private static final Logger log = LoggerFactory.getLogger(TwoPhaseLoad.class);

    private TwoPhaseLoad() {
    }

    public static void postHydrate(EntityPersister entityPersister, Serializable serializable, Object[] objectArray, Object object, Object object2, LockMode lockMode, boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        Object object3 = Versioning.getVersion(objectArray, entityPersister);
        sessionImplementor.getPersistenceContext().addEntry(object2, Status.LOADING, objectArray, object, serializable, object3, lockMode, true, entityPersister, false, bl);
        if (log.isTraceEnabled() && object3 != null) {
            String string = entityPersister.isVersioned() ? entityPersister.getVersionType().toLoggableString(object3, sessionImplementor.getFactory()) : "null";
            log.trace("Version: " + string);
        }
    }

    public static void initializeEntity(Object object, boolean bl, SessionImplementor sessionImplementor, PreLoadEvent preLoadEvent, PostLoadEvent postLoadEvent) throws HibernateException {
        PostLoadEventListener[] postLoadEventListenerArray;
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(object);
        if (entityEntry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        EntityPersister entityPersister = entityEntry.getPersister();
        Serializable serializable = entityEntry.getId();
        Object[] objectArray = entityEntry.getLoadedState();
        if (log.isDebugEnabled()) {
            log.debug("resolving associations for " + MessageHelper.infoString(entityPersister, serializable, sessionImplementor.getFactory()));
        }
        Type[] typeArray = entityPersister.getPropertyTypes();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if (object2 == LazyPropertyInitializer.UNFETCHED_PROPERTY || object2 == BackrefPropertyAccessor.UNKNOWN) continue;
            objectArray[i] = typeArray[i].resolve(object2, sessionImplementor, object);
        }
        if (sessionImplementor.isEventSource()) {
            preLoadEvent.setEntity(object).setState(objectArray).setId(serializable).setPersister(entityPersister);
            PreLoadEventListener[] preLoadEventListenerArray = sessionImplementor.getListeners().getPreLoadEventListeners();
            for (int i = 0; i < preLoadEventListenerArray.length; ++i) {
                preLoadEventListenerArray[i].onPreLoad(preLoadEvent);
            }
        }
        entityPersister.setPropertyValues(object, objectArray, sessionImplementor.getEntityMode());
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        if (entityPersister.hasCache() && sessionImplementor.getCacheMode().isPutEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("adding entity to second-level cache: " + MessageHelper.infoString(entityPersister, serializable, sessionImplementor.getFactory()));
            }
            Object object3 = Versioning.getVersion(objectArray, entityPersister);
            postLoadEventListenerArray = new CacheEntry(objectArray, entityPersister, entityEntry.isLoadedWithLazyPropertiesUnfetched(), object3, sessionImplementor, object);
            CacheKey cacheKey = new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            if (sessionImplementor.getPersistenceContext().wasInsertedDuringTransaction(entityPersister, serializable)) {
                entityPersister.getCacheAccessStrategy().update(cacheKey, entityPersister.getCacheEntryStructure().structure(postLoadEventListenerArray), object3, object3);
            } else {
                boolean bl2 = entityPersister.getCacheAccessStrategy().putFromLoad(cacheKey, entityPersister.getCacheEntryStructure().structure(postLoadEventListenerArray), sessionImplementor.getTimestamp(), object3, TwoPhaseLoad.useMinimalPuts(sessionImplementor, entityEntry));
                if (bl2 && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                    sessionFactoryImplementor.getStatisticsImplementor().secondLevelCachePut(entityPersister.getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
        boolean bl3 = bl;
        if (!entityPersister.isMutable()) {
            bl3 = true;
        } else {
            postLoadEventListenerArray = persistenceContext.getProxy(entityEntry.getEntityKey());
            if (postLoadEventListenerArray != null) {
                bl3 = ((HibernateProxy)postLoadEventListenerArray).getHibernateLazyInitializer().isReadOnly();
            }
        }
        if (bl3) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeHelper.deepCopy(objectArray, entityPersister.getPropertyTypes(), entityPersister.getPropertyUpdateability(), objectArray, sessionImplementor);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        entityPersister.afterInitialize(object, entityEntry.isLoadedWithLazyPropertiesUnfetched(), sessionImplementor);
        if (sessionImplementor.isEventSource()) {
            postLoadEvent.setEntity(object).setId(serializable).setPersister(entityPersister);
            postLoadEventListenerArray = sessionImplementor.getListeners().getPostLoadEventListeners();
            for (int i = 0; i < postLoadEventListenerArray.length; ++i) {
                postLoadEventListenerArray[i].onPostLoad(postLoadEvent);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("done materializing entity " + MessageHelper.infoString(entityPersister, serializable, sessionImplementor.getFactory()));
        }
        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            sessionFactoryImplementor.getStatisticsImplementor().loadEntity(entityPersister.getEntityName());
        }
    }

    private static boolean useMinimalPuts(SessionImplementor sessionImplementor, EntityEntry entityEntry) {
        return sessionImplementor.getFactory().getSettings().isMinimalPutsEnabled() && sessionImplementor.getCacheMode() != CacheMode.REFRESH || entityEntry.getPersister().hasLazyProperties() && entityEntry.isLoadedWithLazyPropertiesUnfetched() && entityEntry.getPersister().isLazyPropertiesCacheable();
    }

    public static void addUninitializedEntity(EntityKey entityKey, Object object, EntityPersister entityPersister, LockMode lockMode, boolean bl, SessionImplementor sessionImplementor) {
        sessionImplementor.getPersistenceContext().addEntity(object, Status.LOADING, null, entityKey, null, lockMode, true, entityPersister, false, bl);
    }

    public static void addUninitializedCachedEntity(EntityKey entityKey, Object object, EntityPersister entityPersister, LockMode lockMode, boolean bl, Object object2, SessionImplementor sessionImplementor) {
        sessionImplementor.getPersistenceContext().addEntity(object, Status.LOADING, null, entityKey, object2, lockMode, true, entityPersister, false, bl);
    }
}

