/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import org.hibernate.MappingException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionValue {
    private static final Logger log = LoggerFactory.getLogger(VersionValue.class);
    private final Object value;
    public static final VersionValue NULL = new VersionValue(){

        public final Boolean isUnsaved(Object object) {
            log.trace("version unsaved-value strategy NULL");
            return object == null ? Boolean.TRUE : Boolean.FALSE;
        }

        public Object getDefaultValue(Object object) {
            return null;
        }

        public String toString() {
            return "VERSION_SAVE_NULL";
        }
    };
    public static final VersionValue UNDEFINED = new VersionValue(){

        public final Boolean isUnsaved(Object object) {
            log.trace("version unsaved-value strategy UNDEFINED");
            return object == null ? Boolean.TRUE : null;
        }

        public Object getDefaultValue(Object object) {
            return object;
        }

        public String toString() {
            return "VERSION_UNDEFINED";
        }
    };
    public static final VersionValue NEGATIVE = new VersionValue(){

        public final Boolean isUnsaved(Object object) throws MappingException {
            log.trace("version unsaved-value strategy NEGATIVE");
            if (object == null) {
                return Boolean.TRUE;
            }
            if (object instanceof Number) {
                return ((Number)object).longValue() < 0L ? Boolean.TRUE : Boolean.FALSE;
            }
            throw new MappingException("unsaved-value NEGATIVE may only be used with short, int and long types");
        }

        public Object getDefaultValue(Object object) {
            return IdentifierGeneratorHelper.getIntegralDataTypeHolder(object.getClass()).initialize(-1L).makeValue();
        }

        public String toString() {
            return "VERSION_NEGATIVE";
        }
    };

    protected VersionValue() {
        this.value = null;
    }

    public VersionValue(Object object) {
        this.value = object;
    }

    public Boolean isUnsaved(Object object) throws MappingException {
        if (log.isTraceEnabled()) {
            log.trace("version unsaved-value: " + this.value);
        }
        return object == null || object.equals(this.value) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object getDefaultValue(Object object) {
        return this.value;
    }

    public String toString() {
        return "version unsaved-value: " + this.value;
    }
}

