/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.type.descriptor.java.BinaryStreamImpl;
import org.hibernate.type.descriptor.java.DataHelper;

public class BlobProxy
implements InvocationHandler {
    private static final Class[] PROXY_INTERFACES = new Class[]{Blob.class, BlobImplementer.class};
    private InputStream stream;
    private long length;
    private boolean needsReset = false;

    private BlobProxy(byte[] byArray) {
        this.stream = new BinaryStreamImpl(byArray);
        this.length = byArray.length;
    }

    private BlobProxy(InputStream inputStream, long l) {
        this.stream = inputStream;
        this.length = l;
    }

    private long getLength() {
        return this.length;
    }

    private InputStream getStream() throws SQLException {
        try {
            if (this.needsReset) {
                this.stream.reset();
            }
        }
        catch (IOException iOException) {
            throw new SQLException("could not reset reader");
        }
        this.needsReset = true;
        return this.stream;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        int n = method.getParameterTypes().length;
        if ("length".equals(string) && n == 0) {
            return this.getLength();
        }
        if ("getBinaryStream".equals(string)) {
            if (n == 0) {
                return this.getStream();
            }
            if (n == 2) {
                long l = (Long)objectArray[0];
                if (l < 1L) {
                    throw new SQLException("Start position 1-based; must be 1 or more.");
                }
                if (l > this.getLength()) {
                    throw new SQLException("Start position [" + l + "] cannot exceed overall CLOB length [" + this.getLength() + "]");
                }
                int n2 = (Integer)objectArray[1];
                if (n2 < 0) {
                    throw new SQLException("Length must be great-than-or-equal to zero.");
                }
                return DataHelper.subStream(this.getStream(), l - 1L, n2);
            }
        }
        if ("getBytes".equals(string) && n == 2) {
            long l = (Long)objectArray[0];
            if (l < 1L) {
                throw new SQLException("Start position 1-based; must be 1 or more.");
            }
            int n3 = (Integer)objectArray[1];
            if (n3 < 0) {
                throw new SQLException("Length must be great-than-or-equal to zero.");
            }
            return DataHelper.extractBytes(this.getStream(), l - 1L, n3);
        }
        if ("free".equals(string) && n == 0) {
            this.stream.close();
            return null;
        }
        if ("toString".equals(string) && n == 0) {
            return this.toString();
        }
        if ("equals".equals(string) && n == 1) {
            return object == objectArray[0];
        }
        if ("hashCode".equals(string) && n == 0) {
            return new Integer(this.hashCode());
        }
        throw new UnsupportedOperationException("Blob may not be manipulated from creating session");
    }

    public static Blob generateProxy(byte[] byArray) {
        return (Blob)Proxy.newProxyInstance(BlobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new BlobProxy(byArray));
    }

    public static Blob generateProxy(InputStream inputStream, long l) {
        return (Blob)Proxy.newProxyInstance(BlobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new BlobProxy(inputStream, l));
    }

    private static ClassLoader getProxyClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = BlobImplementer.class.getClassLoader();
        }
        return classLoader;
    }
}

