/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Clob;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.ClobImplementer;
import org.hibernate.engine.jdbc.ReaderInputStream;
import org.hibernate.type.descriptor.java.DataHelper;

public class ClobProxy
implements InvocationHandler {
    private static final Class[] PROXY_INTERFACES = new Class[]{Clob.class, ClobImplementer.class};
    private String string;
    private Reader reader;
    private long length;
    private boolean needsReset = false;

    protected ClobProxy(String string) {
        this.string = string;
        this.reader = new StringReader(string);
        this.length = string.length();
    }

    protected ClobProxy(Reader reader, long l) {
        this.reader = reader;
        this.length = l;
    }

    protected long getLength() {
        return this.length;
    }

    protected InputStream getAsciiStream() throws SQLException {
        this.resetIfNeeded();
        return new ReaderInputStream(this.reader);
    }

    protected Reader getCharacterStream() throws SQLException {
        this.resetIfNeeded();
        return this.reader;
    }

    protected String getSubString(long l, int n) {
        if (this.string == null) {
            throw new UnsupportedOperationException("Clob was not created from string; cannot substring");
        }
        int n2 = Math.min((int)l + n, this.string.length());
        return this.string.substring((int)l, n2);
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        int n = method.getParameterTypes().length;
        if ("length".equals(string) && n == 0) {
            return this.getLength();
        }
        if ("getAsciiStream".equals(string) && n == 0) {
            return this.getAsciiStream();
        }
        if ("getCharacterStream".equals(string)) {
            if (n == 0) {
                return this.getCharacterStream();
            }
            if (n == 2) {
                long l = (Long)objectArray[0];
                if (l < 1L) {
                    throw new SQLException("Start position 1-based; must be 1 or more.");
                }
                if (l > this.getLength()) {
                    throw new SQLException("Start position [" + l + "] cannot exceed overall CLOB length [" + this.getLength() + "]");
                }
                int n2 = (Integer)objectArray[1];
                if (n2 < 0) {
                    throw new SQLException("Length must be great-than-or-equal to zero.");
                }
                return DataHelper.subStream(this.getCharacterStream(), l - 1L, n2);
            }
        }
        if ("getSubString".equals(string) && n == 2) {
            long l = (Long)objectArray[0];
            if (l < 1L) {
                throw new SQLException("Start position 1-based; must be 1 or more.");
            }
            if (l > this.getLength()) {
                throw new SQLException("Start position [" + l + "] cannot exceed overall CLOB length [" + this.getLength() + "]");
            }
            int n3 = (Integer)objectArray[1];
            if (n3 < 0) {
                throw new SQLException("Length must be great-than-or-equal to zero.");
            }
            return this.getSubString(l - 1L, n3);
        }
        if ("free".equals(string) && n == 0) {
            this.reader.close();
            return null;
        }
        if ("toString".equals(string) && n == 0) {
            return this.toString();
        }
        if ("equals".equals(string) && n == 1) {
            return object == objectArray[0];
        }
        if ("hashCode".equals(string) && n == 0) {
            return new Integer(this.hashCode());
        }
        throw new UnsupportedOperationException("Clob may not be manipulated from creating session");
    }

    protected void resetIfNeeded() throws SQLException {
        try {
            if (this.needsReset) {
                this.reader.reset();
            }
        }
        catch (IOException iOException) {
            throw new SQLException("could not reset reader");
        }
        this.needsReset = true;
    }

    public static Clob generateProxy(String string) {
        return (Clob)Proxy.newProxyInstance(ClobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ClobProxy(string));
    }

    public static Clob generateProxy(Reader reader, long l) {
        return (Clob)Proxy.newProxyInstance(ClobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ClobProxy(reader, l));
    }

    protected static ClassLoader getProxyClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClobImplementer.class.getClassLoader();
        }
        return classLoader;
    }
}

