/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ColumnNameCache {
    public static final float LOAD_FACTOR = 0.75f;
    private final Map columnNameToIndexCache;

    public ColumnNameCache(int n) {
        this.columnNameToIndexCache = new HashMap(n + (int)((float)n * 0.75f) + 1, 0.75f);
    }

    public int getIndexForColumnName(String string, ResultSet resultSet) throws SQLException {
        Integer n = (Integer)this.columnNameToIndexCache.get(string);
        if (n != null) {
            return n;
        }
        int n2 = resultSet.findColumn(string);
        this.columnNameToIndexCache.put(string, new Integer(n2));
        return n2;
    }
}

