/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.JdbcSupport;
import org.hibernate.engine.jdbc.JdbcSupportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSupportLoader {
    private static final Logger log = LoggerFactory.getLogger(JdbcSupportLoader.class);
    private static final Class[] NO_ARG_SIG = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    public static JdbcSupport loadJdbcSupport(Connection connection) {
        return new JdbcSupportImpl(JdbcSupportLoader.useContextualLobCreation(connection));
    }

    private static boolean useContextualLobCreation(Connection connection) {
        block10: {
            if (connection == null) {
                log.info("Disabling contextual LOB creation as connection was null");
                return false;
            }
            try {
                Object object;
                try {
                    object = connection.getMetaData();
                    if (object.getJDBCMajorVersion() < 4) {
                        log.info("Disabling contextual LOB creation as JDBC driver reported JDBC version [" + object.getJDBCMajorVersion() + "] less than 4");
                        return false;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                object = Connection.class;
                Method method = ((Class)object).getMethod("createClob", NO_ARG_SIG);
                if (!method.getDeclaringClass().equals(Connection.class)) break block10;
                try {
                    Object object2 = method.invoke((Object)connection, NO_ARGS);
                    try {
                        Method method2 = object2.getClass().getMethod("free", NO_ARG_SIG);
                        method2.invoke(object2, NO_ARGS);
                    }
                    catch (Throwable throwable) {
                        log.trace("Unable to free CLOB created to test createClob() implementation : " + throwable);
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    log.info("Disabling contextual LOB creation as createClob() method threw error : " + throwable);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }
}

