/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CollectionCacheEntry;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.loading.LoadContexts;
import org.hibernate.engine.loading.LoadingCollectionEntry;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionLoadContext {
    private static final Logger log = LoggerFactory.getLogger(CollectionLoadContext.class);
    private final LoadContexts loadContexts;
    private final ResultSet resultSet;
    private Set localLoadingCollectionKeys = new HashSet();

    public CollectionLoadContext(LoadContexts loadContexts, ResultSet resultSet) {
        this.loadContexts = loadContexts;
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public LoadContexts getLoadContext() {
        return this.loadContexts;
    }

    public PersistentCollection getLoadingCollection(CollectionPersister collectionPersister, Serializable serializable) {
        LoadingCollectionEntry loadingCollectionEntry;
        EntityMode entityMode = this.loadContexts.getPersistenceContext().getSession().getEntityMode();
        CollectionKey collectionKey = new CollectionKey(collectionPersister, serializable, entityMode);
        if (log.isTraceEnabled()) {
            log.trace("starting attempt to find loading collection [" + MessageHelper.collectionInfoString(collectionPersister.getRole(), serializable) + "]");
        }
        if ((loadingCollectionEntry = this.loadContexts.locateLoadingCollectionEntry(collectionKey)) == null) {
            PersistentCollection persistentCollection = this.loadContexts.getPersistenceContext().getCollection(collectionKey);
            if (persistentCollection != null) {
                if (persistentCollection.wasInitialized()) {
                    log.trace("collection already initialized; ignoring");
                    return null;
                }
                log.trace("collection not yet initialized; initializing");
            } else {
                boolean bl;
                Object object = this.loadContexts.getPersistenceContext().getCollectionOwner(serializable, collectionPersister);
                boolean bl2 = bl = object != null && this.loadContexts.getPersistenceContext().getEntry(object).getStatus() != Status.LOADING && entityMode != EntityMode.DOM4J;
                if (bl) {
                    log.trace("owning entity already loaded; ignoring");
                    return null;
                }
                if (log.isTraceEnabled()) {
                    log.trace("instantiating new collection [key=" + serializable + ", rs=" + this.resultSet + "]");
                }
                persistentCollection = collectionPersister.getCollectionType().instantiate(this.loadContexts.getPersistenceContext().getSession(), collectionPersister, serializable);
            }
            persistentCollection.beforeInitialize(collectionPersister, -1);
            persistentCollection.beginRead();
            this.localLoadingCollectionKeys.add(collectionKey);
            this.loadContexts.registerLoadingCollectionXRef(collectionKey, new LoadingCollectionEntry(this.resultSet, collectionPersister, serializable, persistentCollection));
            return persistentCollection;
        }
        if (loadingCollectionEntry.getResultSet() == this.resultSet) {
            log.trace("found loading collection bound to current result set processing; reading row");
            return loadingCollectionEntry.getCollection();
        }
        log.trace("collection is already being initialized; ignoring row");
        return null;
    }

    public void endLoadingCollections(CollectionPersister collectionPersister) {
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        if (!this.loadContexts.hasLoadingCollectionEntries() && this.localLoadingCollectionKeys.isEmpty()) {
            return;
        }
        ArrayList<LoadingCollectionEntry> arrayList = null;
        Iterator iterator = this.localLoadingCollectionKeys.iterator();
        while (iterator.hasNext()) {
            CollectionKey collectionKey = (CollectionKey)iterator.next();
            LoadingCollectionEntry loadingCollectionEntry = this.loadContexts.locateLoadingCollectionEntry(collectionKey);
            if (loadingCollectionEntry == null) {
                log.warn("In CollectionLoadContext#endLoadingCollections, localLoadingCollectionKeys contained [" + collectionKey + "], but no LoadingCollectionEntry was found in loadContexts");
                continue;
            }
            if (loadingCollectionEntry.getResultSet() != this.resultSet || loadingCollectionEntry.getPersister() != collectionPersister) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<LoadingCollectionEntry>();
            }
            arrayList.add(loadingCollectionEntry);
            if (loadingCollectionEntry.getCollection().getOwner() == null) {
                sessionImplementor.getPersistenceContext().addUnownedCollection(new CollectionKey(collectionPersister, loadingCollectionEntry.getKey(), sessionImplementor.getEntityMode()), loadingCollectionEntry.getCollection());
            }
            if (log.isTraceEnabled()) {
                log.trace("removing collection load entry [" + loadingCollectionEntry + "]");
            }
            this.loadContexts.unregisterLoadingCollectionXRef(collectionKey);
            iterator.remove();
        }
        this.endLoadingCollections(collectionPersister, arrayList);
        if (this.localLoadingCollectionKeys.isEmpty()) {
            this.loadContexts.cleanup(this.resultSet);
        }
    }

    private void endLoadingCollections(CollectionPersister collectionPersister, List list) {
        if (list == null) {
            if (log.isDebugEnabled()) {
                log.debug("no collections were found in result set for role: " + collectionPersister.getRole());
            }
            return;
        }
        int n = list.size();
        if (log.isDebugEnabled()) {
            log.debug(n + " collections were found in result set for role: " + collectionPersister.getRole());
        }
        for (int i = 0; i < n; ++i) {
            LoadingCollectionEntry loadingCollectionEntry = (LoadingCollectionEntry)list.get(i);
            this.endLoadingCollection(loadingCollectionEntry, collectionPersister);
        }
        if (log.isDebugEnabled()) {
            log.debug(n + " collections initialized for role: " + collectionPersister.getRole());
        }
    }

    private void endLoadingCollection(LoadingCollectionEntry loadingCollectionEntry, CollectionPersister collectionPersister) {
        boolean bl;
        CollectionEntry collectionEntry;
        if (log.isTraceEnabled()) {
            log.debug("ending loading collection [" + loadingCollectionEntry + "]");
        }
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        EntityMode entityMode = sessionImplementor.getEntityMode();
        boolean bl2 = loadingCollectionEntry.getCollection().endRead();
        if (collectionPersister.getCollectionType().hasHolder(entityMode)) {
            this.getLoadContext().getPersistenceContext().addCollectionHolder(loadingCollectionEntry.getCollection());
        }
        if ((collectionEntry = this.getLoadContext().getPersistenceContext().getCollectionEntry(loadingCollectionEntry.getCollection())) == null) {
            collectionEntry = this.getLoadContext().getPersistenceContext().addInitializedCollection(collectionPersister, loadingCollectionEntry.getCollection(), loadingCollectionEntry.getKey());
        } else {
            collectionEntry.postInitialize(loadingCollectionEntry.getCollection());
        }
        boolean bl3 = bl = bl2 && collectionPersister.hasCache() && sessionImplementor.getCacheMode().isPutEnabled() && !collectionEntry.isDoremove();
        if (bl) {
            this.addCollectionToCache(loadingCollectionEntry, collectionPersister);
        }
        if (log.isDebugEnabled()) {
            log.debug("collection fully initialized: " + MessageHelper.collectionInfoString(collectionPersister, loadingCollectionEntry.getKey(), sessionImplementor.getFactory()));
        }
        if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled()) {
            sessionImplementor.getFactory().getStatisticsImplementor().loadCollection(collectionPersister.getRole());
        }
    }

    private void addCollectionToCache(LoadingCollectionEntry loadingCollectionEntry, CollectionPersister collectionPersister) {
        Object object;
        Object object2;
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        if (log.isDebugEnabled()) {
            log.debug("Caching collection: " + MessageHelper.collectionInfoString(collectionPersister, loadingCollectionEntry.getKey(), sessionFactoryImplementor));
        }
        if (!sessionImplementor.getEnabledFilters().isEmpty() && collectionPersister.isAffectedByEnabledFilters(sessionImplementor)) {
            log.debug("Refusing to add to cache due to enabled filters");
            return;
        }
        if (collectionPersister.isVersioned()) {
            object2 = this.getLoadContext().getPersistenceContext().getCollectionOwner(loadingCollectionEntry.getKey(), collectionPersister);
            object = this.getLoadContext().getPersistenceContext().getEntry(object2).getVersion();
        } else {
            object = null;
        }
        object2 = new CollectionCacheEntry(loadingCollectionEntry.getCollection(), collectionPersister);
        CacheKey cacheKey = new CacheKey(loadingCollectionEntry.getKey(), collectionPersister.getKeyType(), collectionPersister.getRole(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
        boolean bl = collectionPersister.getCacheAccessStrategy().putFromLoad(cacheKey, collectionPersister.getCacheEntryStructure().structure(object2), sessionImplementor.getTimestamp(), object, sessionFactoryImplementor.getSettings().isMinimalPutsEnabled() && sessionImplementor.getCacheMode() != CacheMode.REFRESH);
        if (bl && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            sessionFactoryImplementor.getStatisticsImplementor().secondLevelCachePut(collectionPersister.getCacheAccessStrategy().getRegion().getName());
        }
    }

    void cleanup() {
        if (!this.localLoadingCollectionKeys.isEmpty()) {
            log.warn("On CollectionLoadContext#cleanup, localLoadingCollectionKeys contained [" + this.localLoadingCollectionKeys.size() + "] entries");
        }
        this.loadContexts.cleanupCollectionXRefs(this.localLoadingCollectionKeys);
        this.localLoadingCollectionKeys.clear();
    }

    public String toString() {
        return super.toString() + "<rs=" + this.resultSet + ">";
    }
}

