/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.loading.CollectionLoadContext;
import org.hibernate.engine.loading.EntityLoadContext;
import org.hibernate.engine.loading.LoadingCollectionEntry;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.IdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadContexts {
    private static final Logger log = LoggerFactory.getLogger(LoadContexts.class);
    private final PersistenceContext persistenceContext;
    private Map collectionLoadContexts;
    private Map entityLoadContexts;
    private Map xrefLoadingCollectionEntries;

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    private SessionImplementor getSession() {
        return this.getPersistenceContext().getSession();
    }

    private EntityMode getEntityMode() {
        return this.getSession().getEntityMode();
    }

    public void cleanup(ResultSet resultSet) {
        Object object;
        if (this.collectionLoadContexts != null) {
            object = (CollectionLoadContext)this.collectionLoadContexts.remove(resultSet);
            ((CollectionLoadContext)object).cleanup();
        }
        if (this.entityLoadContexts != null) {
            object = (EntityLoadContext)this.entityLoadContexts.remove(resultSet);
            ((EntityLoadContext)object).cleanup();
        }
    }

    public void cleanup() {
        if (this.collectionLoadContexts != null) {
            for (Object object : this.collectionLoadContexts.values()) {
                log.warn("fail-safe cleanup (collections) : " + object);
                ((CollectionLoadContext)object).cleanup();
            }
            this.collectionLoadContexts.clear();
        }
        if (this.entityLoadContexts != null) {
            for (Object object : this.entityLoadContexts.values()) {
                log.warn("fail-safe cleanup (entities) : " + object);
                ((EntityLoadContext)object).cleanup();
            }
            this.entityLoadContexts.clear();
        }
    }

    public boolean hasLoadingCollectionEntries() {
        return this.collectionLoadContexts != null && !this.collectionLoadContexts.isEmpty();
    }

    public boolean hasRegisteredLoadingCollectionEntries() {
        return this.xrefLoadingCollectionEntries != null && !this.xrefLoadingCollectionEntries.isEmpty();
    }

    public CollectionLoadContext getCollectionLoadContext(ResultSet resultSet) {
        CollectionLoadContext collectionLoadContext = null;
        if (this.collectionLoadContexts == null) {
            this.collectionLoadContexts = IdentityMap.instantiate(8);
        } else {
            collectionLoadContext = (CollectionLoadContext)this.collectionLoadContexts.get(resultSet);
        }
        if (collectionLoadContext == null) {
            if (log.isTraceEnabled()) {
                log.trace("constructing collection load context for result set [" + resultSet + "]");
            }
            collectionLoadContext = new CollectionLoadContext(this, resultSet);
            this.collectionLoadContexts.put(resultSet, collectionLoadContext);
        }
        return collectionLoadContext;
    }

    public PersistentCollection locateLoadingCollection(CollectionPersister collectionPersister, Serializable serializable) {
        LoadingCollectionEntry loadingCollectionEntry = this.locateLoadingCollectionEntry(new CollectionKey(collectionPersister, serializable, this.getEntityMode()));
        if (loadingCollectionEntry != null) {
            if (log.isTraceEnabled()) {
                log.trace("returning loading collection:" + MessageHelper.collectionInfoString(collectionPersister, serializable, this.getSession().getFactory()));
            }
            return loadingCollectionEntry.getCollection();
        }
        if (log.isTraceEnabled()) {
            log.trace("creating collection wrapper:" + MessageHelper.collectionInfoString(collectionPersister, serializable, this.getSession().getFactory()));
        }
        return null;
    }

    void registerLoadingCollectionXRef(CollectionKey collectionKey, LoadingCollectionEntry loadingCollectionEntry) {
        if (this.xrefLoadingCollectionEntries == null) {
            this.xrefLoadingCollectionEntries = new HashMap();
        }
        this.xrefLoadingCollectionEntries.put(collectionKey, loadingCollectionEntry);
    }

    void unregisterLoadingCollectionXRef(CollectionKey collectionKey) {
        if (!this.hasRegisteredLoadingCollectionEntries()) {
            return;
        }
        this.xrefLoadingCollectionEntries.remove(collectionKey);
    }

    Map getLoadingCollectionXRefs() {
        return this.xrefLoadingCollectionEntries;
    }

    LoadingCollectionEntry locateLoadingCollectionEntry(CollectionKey collectionKey) {
        if (this.xrefLoadingCollectionEntries == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("attempting to locate loading collection entry [" + collectionKey + "] in any result-set context");
        }
        LoadingCollectionEntry loadingCollectionEntry = (LoadingCollectionEntry)this.xrefLoadingCollectionEntries.get(collectionKey);
        if (log.isTraceEnabled()) {
            if (loadingCollectionEntry == null) {
                log.trace("collection [" + collectionKey + "] not located in load context");
            } else {
                log.trace("collection [" + collectionKey + "] located in load context");
            }
        }
        return loadingCollectionEntry;
    }

    void cleanupCollectionXRefs(Set set) {
        for (CollectionKey collectionKey : set) {
            this.xrefLoadingCollectionEntries.remove(collectionKey);
        }
    }

    public EntityLoadContext getEntityLoadContext(ResultSet resultSet) {
        EntityLoadContext entityLoadContext = null;
        if (this.entityLoadContexts == null) {
            this.entityLoadContexts = IdentityMap.instantiate(8);
        } else {
            entityLoadContext = (EntityLoadContext)this.entityLoadContexts.get(resultSet);
        }
        if (entityLoadContext == null) {
            entityLoadContext = new EntityLoadContext(this, resultSet);
            this.entityLoadContexts.put(resultSet, entityLoadContext);
        }
        return entityLoadContext;
    }
}

