/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.type.BagType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchProfile {
    private static final Logger log = LoggerFactory.getLogger(FetchProfile.class);
    private final String name;
    private Map<String, Fetch> fetches = new HashMap<String, Fetch>();
    private boolean containsJoinFetchedCollection = false;
    private boolean containsJoinFetchedBag = false;
    private Fetch bagJoinFetch;

    public FetchProfile(String string) {
        this.name = string;
    }

    public void addFetch(Association association, String string) {
        this.addFetch(association, Fetch.Style.parse(string));
    }

    public void addFetch(Association association, Fetch.Style style) {
        this.addFetch(new Fetch(association, style));
    }

    public void addFetch(Fetch fetch) {
        Type type = fetch.getAssociation().getOwner().getPropertyType(fetch.getAssociation().getAssociationPath());
        if (type.isCollectionType()) {
            log.trace("handling request to add collection fetch [{}]", (Object)fetch.getAssociation().getRole());
            if (Fetch.Style.JOIN == fetch.getStyle()) {
                if (BagType.class.isInstance(type) && this.containsJoinFetchedCollection) {
                    log.warn("Ignoring bag join fetch [{}] due to prior collection join fetch", (Object)fetch.getAssociation().getRole());
                    return;
                }
                if (this.containsJoinFetchedBag) {
                    if (this.fetches.remove(this.bagJoinFetch.getAssociation().getRole()) != this.bagJoinFetch) {
                        log.warn("Unable to erase previously added bag join fetch");
                    }
                    this.bagJoinFetch = null;
                    this.containsJoinFetchedBag = false;
                }
                this.containsJoinFetchedCollection = true;
            }
        }
        this.fetches.put(fetch.getAssociation().getRole(), fetch);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Fetch> getFetches() {
        return this.fetches;
    }

    public Fetch getFetchByRole(String string) {
        return this.fetches.get(string);
    }

    public boolean isContainsJoinFetchedCollection() {
        return this.containsJoinFetchedCollection;
    }

    public boolean isContainsJoinFetchedBag() {
        return this.containsJoinFetchedBag;
    }
}

