/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.NamedParameterDescriptor;
import org.hibernate.engine.query.OrdinalParameterDescriptor;
import org.hibernate.engine.query.ParamLocationRecognizer;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.engine.query.ReturnMetadata;
import org.hibernate.event.EventSource;
import org.hibernate.hql.FilterTranslator;
import org.hibernate.hql.ParameterTranslations;
import org.hibernate.hql.QuerySplitter;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.IdentitySet;
import org.hibernate.util.JoinedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HQLQueryPlan
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(HQLQueryPlan.class);
    private final String sourceQuery;
    private final QueryTranslator[] translators;
    private final String[] sqlStrings;
    private final ParameterMetadata parameterMetadata;
    private final ReturnMetadata returnMetadata;
    private final Set querySpaces;
    private final Set enabledFilterNames;
    private final boolean shallow;

    public HQLQueryPlan(String string, boolean bl, Map map, SessionFactoryImplementor sessionFactoryImplementor) {
        this(string, null, bl, map, sessionFactoryImplementor);
    }

    protected HQLQueryPlan(String string, String string2, boolean bl, Map map, SessionFactoryImplementor sessionFactoryImplementor) {
        int n;
        this.sourceQuery = string;
        this.shallow = bl;
        HashSet hashSet = new HashSet();
        hashSet.addAll(map.keySet());
        this.enabledFilterNames = Collections.unmodifiableSet(hashSet);
        HashSet hashSet2 = new HashSet();
        String[] stringArray = QuerySplitter.concreteQueries(string, sessionFactoryImplementor);
        int n2 = stringArray.length;
        this.translators = new QueryTranslator[n2];
        ArrayList arrayList = new ArrayList();
        for (n = 0; n < n2; ++n) {
            if (string2 == null) {
                this.translators[n] = sessionFactoryImplementor.getSettings().getQueryTranslatorFactory().createQueryTranslator(string, stringArray[n], map, sessionFactoryImplementor);
                this.translators[n].compile(sessionFactoryImplementor.getSettings().getQuerySubstitutions(), bl);
            } else {
                this.translators[n] = sessionFactoryImplementor.getSettings().getQueryTranslatorFactory().createFilterTranslator(string, stringArray[n], map, sessionFactoryImplementor);
                ((FilterTranslator)this.translators[n]).compile(string2, sessionFactoryImplementor.getSettings().getQuerySubstitutions(), bl);
            }
            hashSet2.addAll(this.translators[n].getQuerySpaces());
            arrayList.addAll(this.translators[n].collectSqlStrings());
        }
        this.sqlStrings = ArrayHelper.toStringArray(arrayList);
        this.querySpaces = hashSet2;
        if (n2 == 0) {
            this.parameterMetadata = new ParameterMetadata(null, null);
            this.returnMetadata = null;
        } else {
            this.parameterMetadata = this.buildParameterMetadata(this.translators[0].getParameterTranslations(), string);
            if (this.translators[0].isManipulationStatement()) {
                this.returnMetadata = null;
            } else if (n2 > 1) {
                n = this.translators[0].getReturnTypes().length;
                this.returnMetadata = new ReturnMetadata(this.translators[0].getReturnAliases(), new Type[n]);
            } else {
                this.returnMetadata = new ReturnMetadata(this.translators[0].getReturnAliases(), this.translators[0].getReturnTypes());
            }
        }
    }

    public String getSourceQuery() {
        return this.sourceQuery;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public ParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }

    public ReturnMetadata getReturnMetadata() {
        return this.returnMetadata;
    }

    public Set getEnabledFilterNames() {
        return this.enabledFilterNames;
    }

    public String[] getSqlStrings() {
        return this.sqlStrings;
    }

    public Set getUtilizedFilterNames() {
        return null;
    }

    public boolean isShallow() {
        return this.shallow;
    }

    public List performList(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        QueryParameters queryParameters2;
        Object object;
        boolean bl;
        if (log.isTraceEnabled()) {
            log.trace("find: " + this.getSourceQuery());
            queryParameters.traceParameters(sessionImplementor.getFactory());
        }
        boolean bl2 = queryParameters.getRowSelection() != null && queryParameters.getRowSelection().definesLimits();
        boolean bl3 = bl = bl2 && this.translators.length > 1;
        if (bl) {
            log.warn("firstResult/maxResults specified on polymorphic query; applying in memory!");
            object = new RowSelection();
            ((RowSelection)object).setFetchSize(queryParameters.getRowSelection().getFetchSize());
            ((RowSelection)object).setTimeout(queryParameters.getRowSelection().getTimeout());
            queryParameters2 = queryParameters.createCopyUsing((RowSelection)object);
        } else {
            queryParameters2 = queryParameters;
        }
        object = new ArrayList();
        IdentitySet identitySet = new IdentitySet();
        int n = -1;
        block0: for (int i = 0; i < this.translators.length; ++i) {
            List list = this.translators[i].list(sessionImplementor, queryParameters2);
            if (bl) {
                int n2 = queryParameters.getRowSelection().getFirstRow() == null ? 0 : queryParameters.getRowSelection().getFirstRow();
                int n3 = queryParameters.getRowSelection().getMaxRows() == null ? -1 : queryParameters.getRowSelection().getMaxRows();
                int n4 = list.size();
                for (int j = 0; j < n4; ++j) {
                    Object e = list.get(j);
                    if (!identitySet.add(e) || ++n < n2) continue;
                    object.add(e);
                    if (n3 >= 0 && n > n3) break block0;
                }
                continue;
            }
            object.addAll(list);
        }
        return object;
    }

    public Iterator performIterate(QueryParameters queryParameters, EventSource eventSource) throws HibernateException {
        boolean bl;
        if (log.isTraceEnabled()) {
            log.trace("iterate: " + this.getSourceQuery());
            queryParameters.traceParameters(eventSource.getFactory());
        }
        if (this.translators.length == 0) {
            return EmptyIterator.INSTANCE;
        }
        Iterator[] iteratorArray = null;
        boolean bl2 = bl = this.translators.length > 1;
        if (bl) {
            iteratorArray = new Iterator[this.translators.length];
        }
        Iterator iterator = null;
        for (int i = 0; i < this.translators.length; ++i) {
            iterator = this.translators[i].iterate(queryParameters, eventSource);
            if (!bl) continue;
            iteratorArray[i] = iterator;
        }
        return bl ? new JoinedIterator(iteratorArray) : iterator;
    }

    public ScrollableResults performScroll(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("iterate: " + this.getSourceQuery());
            queryParameters.traceParameters(sessionImplementor.getFactory());
        }
        if (this.translators.length != 1) {
            throw new QueryException("implicit polymorphism not supported for scroll() queries");
        }
        if (queryParameters.getRowSelection().definesLimits() && this.translators[0].containsCollectionFetches()) {
            throw new QueryException("firstResult/maxResults not supported in conjunction with scroll() of a query containing collection fetches");
        }
        return this.translators[0].scroll(queryParameters, sessionImplementor);
    }

    public int performExecuteUpdate(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("executeUpdate: " + this.getSourceQuery());
            queryParameters.traceParameters(sessionImplementor.getFactory());
        }
        if (this.translators.length != 1) {
            log.warn("manipulation query [" + this.getSourceQuery() + "] resulted in [" + this.translators.length + "] split queries");
        }
        int n = 0;
        for (int i = 0; i < this.translators.length; ++i) {
            n += this.translators[i].executeUpdate(queryParameters, sessionImplementor);
        }
        return n;
    }

    private ParameterMetadata buildParameterMetadata(ParameterTranslations parameterTranslations, String string) {
        long l = System.currentTimeMillis();
        ParamLocationRecognizer paramLocationRecognizer = ParamLocationRecognizer.parseLocations(string);
        long l2 = System.currentTimeMillis();
        if (log.isTraceEnabled()) {
            log.trace("HQL param location recognition took " + (l2 - l) + " mills (" + string + ")");
        }
        int n = parameterTranslations.getOrdinalParameterCount();
        int[] nArray = ArrayHelper.toIntArray(paramLocationRecognizer.getOrdinalParameterLocationList());
        if (parameterTranslations.supportsOrdinalParameterMetadata() && nArray.length != n) {
            throw new HibernateException("ordinal parameter mismatch");
        }
        n = nArray.length;
        OrdinalParameterDescriptor[] ordinalParameterDescriptorArray = new OrdinalParameterDescriptor[n];
        for (int i = 1; i <= n; ++i) {
            ordinalParameterDescriptorArray[i - 1] = new OrdinalParameterDescriptor(i, parameterTranslations.supportsOrdinalParameterMetadata() ? parameterTranslations.getOrdinalParameterExpectedType(i) : null, nArray[i - 1]);
        }
        Iterator iterator = paramLocationRecognizer.getNamedParameterDescriptionMap().entrySet().iterator();
        HashMap<String, NamedParameterDescriptor> hashMap = new HashMap<String, NamedParameterDescriptor>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            ParamLocationRecognizer.NamedParameterDescription namedParameterDescription = (ParamLocationRecognizer.NamedParameterDescription)entry.getValue();
            hashMap.put(string2, new NamedParameterDescriptor(string2, parameterTranslations.getNamedParameterExpectedType(string2), namedParameterDescription.buildPositionsArray(), namedParameterDescription.isJpaStyle()));
        }
        return new ParameterMetadata(ordinalParameterDescriptorArray, hashMap);
    }

    public QueryTranslator[] getTranslators() {
        QueryTranslator[] queryTranslatorArray = new QueryTranslator[this.translators.length];
        System.arraycopy(this.translators, 0, queryTranslatorArray, 0, queryTranslatorArray.length);
        return queryTranslatorArray;
    }
}

