/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import org.hibernate.QueryException;
import org.hibernate.util.StringHelper;

public class ParameterParser {
    private ParameterParser() {
    }

    public static void parse(String string, Recognizer recognizer) throws QueryException {
        boolean bl = ParameterParser.startsWithEscapeCallTemplate(string);
        boolean bl2 = false;
        int n = string.length();
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            String string2;
            int n2;
            int n3;
            char c = string.charAt(i);
            if (bl3) {
                if ('\'' == c) {
                    bl3 = false;
                }
                recognizer.other(c);
                continue;
            }
            if ('\'' == c) {
                bl3 = true;
                recognizer.other(c);
                continue;
            }
            if (c == ':') {
                n3 = StringHelper.firstIndexOfChar(string, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", i + 1);
                n2 = n3 < 0 ? string.length() : n3;
                string2 = string.substring(i + 1, n2);
                if (StringHelper.isEmpty(string2)) {
                    throw new QueryException("Space is not allowed after parameter prefix ':' [" + string + "]");
                }
                recognizer.namedParameter(string2, i);
                i = n2 - 1;
                continue;
            }
            if (c == '?') {
                if (i < n - 1 && Character.isDigit(string.charAt(i + 1))) {
                    n3 = StringHelper.firstIndexOfChar(string, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", i + 1);
                    n2 = n3 < 0 ? string.length() : n3;
                    string2 = string.substring(i + 1, n2);
                    try {
                        new Integer(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new QueryException("JPA-style positional param was not an integral ordinal");
                    }
                    recognizer.jpaPositionalParameter(string2, i);
                    i = n2 - 1;
                    continue;
                }
                if (bl && !bl2) {
                    bl2 = true;
                    recognizer.outParameter(i);
                    continue;
                }
                recognizer.ordinalParameter(i);
                continue;
            }
            recognizer.other(c);
        }
    }

    public static boolean startsWithEscapeCallTemplate(String string) {
        if (!string.startsWith("{") || !string.endsWith("}")) {
            return false;
        }
        int n = string.indexOf("call");
        if (n <= 0) {
            return false;
        }
        String string2 = string.substring(1, n + 4);
        int n2 = 0;
        boolean bl = true;
        int n3 = string2.length();
        for (int i = 0; i < n3; ++i) {
            char c = Character.toLowerCase(string2.charAt(i));
            if (Character.isWhitespace(c)) continue;
            if (c == "?=call".charAt(n2)) {
                ++n2;
                continue;
            }
            bl = false;
            break;
        }
        return bl;
    }

    public static interface Recognizer {
        public void outParameter(int var1);

        public void ordinalParameter(int var1);

        public void namedParameter(String var1, int var2);

        public void jpaPositionalParameter(String var1, int var2);

        public void other(char var1);
    }
}

