/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.FilterQueryPlan;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NamedParameterDescriptor;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.engine.query.OrdinalParameterDescriptor;
import org.hibernate.engine.query.ParamLocationRecognizer;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.impl.FilterImpl;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.SimpleMRUCache;
import org.hibernate.util.SoftLimitMRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPlanCache
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(QueryPlanCache.class);
    private SessionFactoryImplementor factory;
    private final SimpleMRUCache sqlParamMetadataCache;
    private final SoftLimitMRUCache planCache;

    public QueryPlanCache(SessionFactoryImplementor sessionFactoryImplementor) {
        int n = PropertiesHelper.getInt("hibernate.query.plan_cache_max_strong_references", sessionFactoryImplementor.getProperties(), 128);
        int n2 = PropertiesHelper.getInt("hibernate.query.plan_cache_max_soft_references", sessionFactoryImplementor.getProperties(), 2048);
        this.factory = sessionFactoryImplementor;
        this.sqlParamMetadataCache = new SimpleMRUCache(n);
        this.planCache = new SoftLimitMRUCache(n, n2);
    }

    public ParameterMetadata getSQLParameterMetadata(String string) {
        ParameterMetadata parameterMetadata = (ParameterMetadata)this.sqlParamMetadataCache.get(string);
        if (parameterMetadata == null) {
            parameterMetadata = this.buildNativeSQLParameterMetadata(string);
            this.sqlParamMetadataCache.put(string, parameterMetadata);
        }
        return parameterMetadata;
    }

    public HQLQueryPlan getHQLQueryPlan(String string, boolean bl, Map map) throws QueryException, MappingException {
        HQLQueryPlanKey hQLQueryPlanKey = new HQLQueryPlanKey(string, bl, map);
        HQLQueryPlan hQLQueryPlan = (HQLQueryPlan)this.planCache.get(hQLQueryPlanKey);
        if (hQLQueryPlan == null) {
            if (log.isTraceEnabled()) {
                log.trace("unable to locate HQL query plan in cache; generating (" + string + ")");
            }
            hQLQueryPlan = new HQLQueryPlan(string, bl, map, this.factory);
        } else if (log.isTraceEnabled()) {
            log.trace("located HQL query plan in cache (" + string + ")");
        }
        this.planCache.put(hQLQueryPlanKey, hQLQueryPlan);
        return hQLQueryPlan;
    }

    public FilterQueryPlan getFilterQueryPlan(String string, String string2, boolean bl, Map map) throws QueryException, MappingException {
        FilterQueryPlanKey filterQueryPlanKey = new FilterQueryPlanKey(string, string2, bl, map);
        FilterQueryPlan filterQueryPlan = (FilterQueryPlan)this.planCache.get(filterQueryPlanKey);
        if (filterQueryPlan == null) {
            if (log.isTraceEnabled()) {
                log.trace("unable to locate collection-filter query plan in cache; generating (" + string2 + " : " + string + ")");
            }
            filterQueryPlan = new FilterQueryPlan(string, string2, bl, map, this.factory);
        } else if (log.isTraceEnabled()) {
            log.trace("located collection-filter query plan in cache (" + string2 + " : " + string + ")");
        }
        this.planCache.put(filterQueryPlanKey, filterQueryPlan);
        return filterQueryPlan;
    }

    public NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification nativeSQLQuerySpecification) {
        NativeSQLQueryPlan nativeSQLQueryPlan = (NativeSQLQueryPlan)this.planCache.get(nativeSQLQuerySpecification);
        if (nativeSQLQueryPlan == null) {
            if (log.isTraceEnabled()) {
                log.trace("unable to locate native-sql query plan in cache; generating (" + nativeSQLQuerySpecification.getQueryString() + ")");
            }
            nativeSQLQueryPlan = new NativeSQLQueryPlan(nativeSQLQuerySpecification, this.factory);
        } else if (log.isTraceEnabled()) {
            log.trace("located native-sql query plan in cache (" + nativeSQLQuerySpecification.getQueryString() + ")");
        }
        this.planCache.put(nativeSQLQuerySpecification, nativeSQLQueryPlan);
        return nativeSQLQueryPlan;
    }

    private ParameterMetadata buildNativeSQLParameterMetadata(String string) {
        Serializable serializable;
        ParamLocationRecognizer paramLocationRecognizer = ParamLocationRecognizer.parseLocations(string);
        OrdinalParameterDescriptor[] ordinalParameterDescriptorArray = new OrdinalParameterDescriptor[paramLocationRecognizer.getOrdinalParameterLocationList().size()];
        for (int i = 0; i < paramLocationRecognizer.getOrdinalParameterLocationList().size(); ++i) {
            serializable = (Integer)paramLocationRecognizer.getOrdinalParameterLocationList().get(i);
            ordinalParameterDescriptorArray[i] = new OrdinalParameterDescriptor(i, null, (Integer)serializable);
        }
        Iterator iterator = paramLocationRecognizer.getNamedParameterDescriptionMap().entrySet().iterator();
        serializable = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            ParamLocationRecognizer.NamedParameterDescription namedParameterDescription = (ParamLocationRecognizer.NamedParameterDescription)entry.getValue();
            serializable.put(string2, new NamedParameterDescriptor(string2, null, namedParameterDescription.buildPositionsArray(), namedParameterDescription.isJpaStyle()));
        }
        return new ParameterMetadata(ordinalParameterDescriptorArray, (Map)((Object)serializable));
    }

    private static class FilterQueryPlanKey
    implements Serializable {
        private final String query;
        private final String collectionRole;
        private final boolean shallow;
        private final Set<String> filterNames;
        private final int hashCode;

        public FilterQueryPlanKey(String string, String string2, boolean bl, Map map) {
            this.query = string;
            this.collectionRole = string2;
            this.shallow = bl;
            if (map == null || map.isEmpty()) {
                this.filterNames = Collections.emptySet();
            } else {
                HashSet hashSet = new HashSet();
                hashSet.addAll(map.keySet());
                this.filterNames = Collections.unmodifiableSet(hashSet);
            }
            int n = string.hashCode();
            n = 29 * n + string2.hashCode();
            n = 29 * n + (bl ? 1 : 0);
            this.hashCode = n = 29 * n + ((Object)this.filterNames).hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FilterQueryPlanKey filterQueryPlanKey = (FilterQueryPlanKey)object;
            return this.shallow == filterQueryPlanKey.shallow && ((Object)this.filterNames).equals(filterQueryPlanKey.filterNames) && this.query.equals(filterQueryPlanKey.query) && this.collectionRole.equals(filterQueryPlanKey.collectionRole);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class DynamicFilterKey
    implements Serializable {
        private final String filterName;
        private final Map<String, Integer> parameterMetadata;
        private final int hashCode;

        private DynamicFilterKey(FilterImpl filterImpl) {
            this.filterName = filterImpl.getName();
            if (filterImpl.getParameters().isEmpty()) {
                this.parameterMetadata = Collections.emptyMap();
            } else {
                this.parameterMetadata = new HashMap<String, Integer>(CollectionHelper.determineProperSizing(filterImpl.getParameters()), 0.75f);
                Iterator iterator = filterImpl.getParameters().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry entry2 = entry = iterator.next();
                    String string = (String)entry2.getKey();
                    Integer n = Collection.class.isInstance(entry2.getValue()) ? new Integer(((Collection)entry2.getValue()).size()) : new Integer(1);
                    this.parameterMetadata.put(string, n);
                }
            }
            int n = this.filterName.hashCode();
            this.hashCode = n = 31 * n + ((Object)this.parameterMetadata).hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DynamicFilterKey dynamicFilterKey = (DynamicFilterKey)object;
            return this.filterName.equals(dynamicFilterKey.filterName) && ((Object)this.parameterMetadata).equals(dynamicFilterKey.parameterMetadata);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class HQLQueryPlanKey
    implements Serializable {
        private final String query;
        private final boolean shallow;
        private final Set<DynamicFilterKey> filterKeys;
        private final int hashCode;

        public HQLQueryPlanKey(String string, boolean bl, Map map) {
            this.query = string;
            this.shallow = bl;
            if (map == null || map.isEmpty()) {
                this.filterKeys = Collections.emptySet();
            } else {
                HashSet<DynamicFilterKey> hashSet = new HashSet<DynamicFilterKey>(CollectionHelper.determineProperSizing(map), 0.75f);
                for (Object v : map.values()) {
                    hashSet.add(new DynamicFilterKey((FilterImpl)v));
                }
                this.filterKeys = Collections.unmodifiableSet(hashSet);
            }
            int n = string.hashCode();
            n = 29 * n + (bl ? 1 : 0);
            this.hashCode = n = 29 * n + ((Object)this.filterKeys).hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            HQLQueryPlanKey hQLQueryPlanKey = (HQLQueryPlanKey)object;
            return this.shallow == hQLQueryPlanKey.shallow && ((Object)this.filterKeys).equals(hQLQueryPlanKey.filterKeys) && this.query.equals(hQLQueryPlanKey.query);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

