/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Isolater {
    private static final Logger log = LoggerFactory.getLogger(Isolater.class);

    public static void doIsolatedWork(IsolatedWork isolatedWork, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl;
        boolean bl2 = bl = sessionImplementor.getFactory().getTransactionManager() != null;
        if (bl) {
            new JtaDelegate(sessionImplementor).delegateWork(isolatedWork, true);
        } else {
            new JdbcDelegate(sessionImplementor).delegateWork(isolatedWork, true);
        }
    }

    public static void doNonTransactedWork(IsolatedWork isolatedWork, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl;
        boolean bl2 = bl = sessionImplementor.getFactory().getTransactionManager() != null;
        if (bl) {
            new JtaDelegate(sessionImplementor).delegateWork(isolatedWork, false);
        } else {
            new JdbcDelegate(sessionImplementor).delegateWork(isolatedWork, false);
        }
    }

    public static class JdbcDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JdbcDelegate(SessionImplementor sessionImplementor) {
            this.session = sessionImplementor;
        }

        public void delegateWork(IsolatedWork isolatedWork, boolean bl) throws HibernateException {
            boolean bl2 = false;
            try {
                Connection connection = this.session.getFactory().getConnectionProvider().getConnection();
                try {
                    if (bl && connection.getAutoCommit()) {
                        bl2 = true;
                        connection.setAutoCommit(false);
                    }
                    isolatedWork.doWork(connection);
                    if (bl) {
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    try {
                        if (bl && !connection.isClosed()) {
                            connection.rollback();
                        }
                    }
                    catch (Exception exception2) {
                        log.info("unable to rollback connection on exception [" + exception2 + "]");
                    }
                    if (exception instanceof HibernateException) {
                        throw (HibernateException)exception;
                    }
                    if (exception instanceof SQLException) {
                        throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), (SQLException)exception, "error performing isolated work");
                    }
                    throw new HibernateException("error performing isolated work", exception);
                }
                finally {
                    if (bl && bl2) {
                        try {
                            connection.setAutoCommit(true);
                        }
                        catch (Exception exception) {
                            log.trace("was unable to reset connection back to auto-commit");
                        }
                    }
                    try {
                        this.session.getFactory().getConnectionProvider().closeConnection(connection);
                    }
                    catch (Exception exception) {
                        log.info("Unable to release isolated connection [" + exception + "]");
                    }
                }
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), sQLException, "unable to obtain isolated JDBC connection");
            }
        }

        private SQLExceptionConverter sqlExceptionConverter() {
            return this.session.getFactory().getSQLExceptionConverter();
        }
    }

    public static class JtaDelegate
    implements Delegate {
        private final SessionImplementor session;

        public JtaDelegate(SessionImplementor sessionImplementor) {
            this.session = sessionImplementor;
        }

        public void delegateWork(IsolatedWork isolatedWork, boolean bl) throws HibernateException {
            TransactionManager transactionManager = this.session.getFactory().getTransactionManager();
            try {
                Transaction transaction = transactionManager.suspend();
                if (log.isDebugEnabled()) {
                    log.debug("surrounding JTA transaction suspended [" + transaction + "]");
                }
                boolean bl2 = false;
                try {
                    if (bl) {
                        this.doTheWorkInNewTransaction(isolatedWork, transactionManager);
                    } else {
                        this.doTheWorkInNoTransaction(isolatedWork);
                    }
                }
                catch (HibernateException hibernateException) {
                    bl2 = true;
                    throw hibernateException;
                }
                finally {
                    block16: {
                        try {
                            transactionManager.resume(transaction);
                            if (log.isDebugEnabled()) {
                                log.debug("surrounding JTA transaction resumed [" + transaction + "]");
                            }
                        }
                        catch (Throwable throwable) {
                            if (bl2) break block16;
                            throw new HibernateException("Unable to resume previously suspended transaction", throwable);
                        }
                    }
                }
            }
            catch (SystemException systemException) {
                throw new HibernateException("Unable to suspend current JTA transaction", systemException);
            }
        }

        private void doTheWorkInNewTransaction(IsolatedWork isolatedWork, TransactionManager transactionManager) {
            try {
                transactionManager.begin();
                try {
                    this.doTheWork(isolatedWork);
                    transactionManager.commit();
                }
                catch (Exception exception) {
                    try {
                        transactionManager.rollback();
                    }
                    catch (Exception exception2) {
                        log.info("Unable to rollback isolated transaction on error [" + exception + "] : [" + exception2 + "]");
                    }
                }
            }
            catch (SystemException systemException) {
                throw new HibernateException("Unable to start isolated transaction", systemException);
            }
            catch (NotSupportedException notSupportedException) {
                throw new HibernateException("Unable to start isolated transaction", notSupportedException);
            }
        }

        private void doTheWorkInNoTransaction(IsolatedWork isolatedWork) {
            this.doTheWork(isolatedWork);
        }

        private void doTheWork(IsolatedWork isolatedWork) {
            try {
                Connection connection = this.session.getFactory().getConnectionProvider().getConnection();
                try {
                    isolatedWork.doWork(connection);
                }
                catch (HibernateException hibernateException) {
                    throw hibernateException;
                }
                catch (Exception exception) {
                    throw new HibernateException("Unable to perform isolated work", exception);
                }
                finally {
                    try {
                        this.session.getFactory().getConnectionProvider().closeConnection(connection);
                    }
                    catch (Throwable throwable) {
                        log.info("Unable to release isolated connection [" + throwable + "]");
                    }
                }
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(this.sqlExceptionConverter(), sQLException, "unable to obtain isolated JDBC connection");
            }
        }

        private SQLExceptionConverter sqlExceptionConverter() {
            return this.session.getFactory().getSQLExceptionConverter();
        }
    }

    private static interface Delegate {
        public void delegateWork(IsolatedWork var1, boolean var2) throws HibernateException;
    }
}

