/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.EventSource;
import org.hibernate.persister.collection.CollectionPersister;

public abstract class AbstractCollectionEvent
extends AbstractEvent {
    private final PersistentCollection collection;
    private final Object affectedOwner;
    private final Serializable affectedOwnerId;
    private final String affectedOwnerEntityName;

    public AbstractCollectionEvent(CollectionPersister collectionPersister, PersistentCollection persistentCollection, EventSource eventSource, Object object, Serializable serializable) {
        super(eventSource);
        this.collection = persistentCollection;
        this.affectedOwner = object;
        this.affectedOwnerId = serializable;
        this.affectedOwnerEntityName = AbstractCollectionEvent.getAffectedOwnerEntityName(collectionPersister, object, eventSource);
    }

    protected static CollectionPersister getLoadedCollectionPersister(PersistentCollection persistentCollection, EventSource eventSource) {
        CollectionEntry collectionEntry = eventSource.getPersistenceContext().getCollectionEntry(persistentCollection);
        return collectionEntry == null ? null : collectionEntry.getLoadedPersister();
    }

    protected static Object getLoadedOwnerOrNull(PersistentCollection persistentCollection, EventSource eventSource) {
        return eventSource.getPersistenceContext().getLoadedCollectionOwnerOrNull(persistentCollection);
    }

    protected static Serializable getLoadedOwnerIdOrNull(PersistentCollection persistentCollection, EventSource eventSource) {
        return eventSource.getPersistenceContext().getLoadedCollectionOwnerIdOrNull(persistentCollection);
    }

    protected static Serializable getOwnerIdOrNull(Object object, EventSource eventSource) {
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
        return entityEntry == null ? null : entityEntry.getId();
    }

    protected static String getAffectedOwnerEntityName(CollectionPersister collectionPersister, Object object, EventSource eventSource) {
        EntityEntry entityEntry;
        String string;
        String string2 = string = collectionPersister == null ? null : collectionPersister.getOwnerEntityPersister().getEntityName();
        if (object != null && (entityEntry = eventSource.getPersistenceContext().getEntry(object)) != null && entityEntry.getEntityName() != null) {
            string = entityEntry.getEntityName();
        }
        return string;
    }

    public PersistentCollection getCollection() {
        return this.collection;
    }

    public Object getAffectedOwnerOrNull() {
        return this.affectedOwner;
    }

    public Serializable getAffectedOwnerIdOrNull() {
        return this.affectedOwnerId;
    }

    public String getAffectedOwnerEntityName() {
        return this.affectedOwnerEntityName;
    }
}

